// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The Security Settings of managed instance DTC.
/// </summary>
public partial class ManagedInstanceDtcSecuritySettings : ProvisionableConstruct
{
    /// <summary>
    /// Transaction Manager communication settings of managed instance DTC.
    /// </summary>
    public ManagedInstanceDtcTransactionManagerCommunicationSettings TransactionManagerCommunicationSettings 
    {
        get { Initialize(); return _transactionManagerCommunicationSettings!; }
        set { Initialize(); AssignOrReplace(ref _transactionManagerCommunicationSettings, value); }
    }
    private ManagedInstanceDtcTransactionManagerCommunicationSettings? _transactionManagerCommunicationSettings;

    /// <summary>
    /// Allow XA Transactions to managed instance DTC.
    /// </summary>
    public BicepValue<bool> IsXATransactionsEnabled 
    {
        get { Initialize(); return _isXATransactionsEnabled!; }
        set { Initialize(); _isXATransactionsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isXATransactionsEnabled;

    /// <summary>
    /// Allow SNA LU 6.2 Transactions to managed instance DTC.
    /// </summary>
    public BicepValue<bool> SnaLu6Point2TransactionsEnabled 
    {
        get { Initialize(); return _snaLu6Point2TransactionsEnabled!; }
        set { Initialize(); _snaLu6Point2TransactionsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _snaLu6Point2TransactionsEnabled;

    /// <summary>
    /// Default timeout for XA Transactions (in seconds).
    /// </summary>
    public BicepValue<int> XATransactionsDefaultTimeoutInSeconds 
    {
        get { Initialize(); return _xATransactionsDefaultTimeoutInSeconds!; }
        set { Initialize(); _xATransactionsDefaultTimeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _xATransactionsDefaultTimeoutInSeconds;

    /// <summary>
    /// Maximum timeout for XA Transactions (in seconds).
    /// </summary>
    public BicepValue<int> XATransactionsMaximumTimeoutInSeconds 
    {
        get { Initialize(); return _xATransactionsMaximumTimeoutInSeconds!; }
        set { Initialize(); _xATransactionsMaximumTimeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _xATransactionsMaximumTimeoutInSeconds;

    /// <summary>
    /// Creates a new ManagedInstanceDtcSecuritySettings.
    /// </summary>
    public ManagedInstanceDtcSecuritySettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedInstanceDtcSecuritySettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _transactionManagerCommunicationSettings = DefineModelProperty<ManagedInstanceDtcTransactionManagerCommunicationSettings>("TransactionManagerCommunicationSettings", ["transactionManagerCommunicationSettings"]);
        _isXATransactionsEnabled = DefineProperty<bool>("IsXATransactionsEnabled", ["xaTransactionsEnabled"]);
        _snaLu6Point2TransactionsEnabled = DefineProperty<bool>("SnaLu6Point2TransactionsEnabled", ["snaLu6point2TransactionsEnabled"]);
        _xATransactionsDefaultTimeoutInSeconds = DefineProperty<int>("XATransactionsDefaultTimeoutInSeconds", ["xaTransactionsDefaultTimeout"]);
        _xATransactionsMaximumTimeoutInSeconds = DefineProperty<int>("XATransactionsMaximumTimeoutInSeconds", ["xaTransactionsMaximumTimeout"]);
    }
}
