// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.Sql;

/// <summary>
/// Managed database create mode. PointInTimeRestore: Create a database by
/// restoring a point in time backup of an existing database.
/// SourceDatabaseName, SourceManagedInstanceName and PointInTime must be
/// specified. RestoreExternalBackup: Create a database by restoring from
/// external backup files. Collation, StorageContainerUri and
/// StorageContainerSasToken must be specified. Recovery: Creates a database
/// by restoring a geo-replicated backup. RecoverableDatabaseId must be
/// specified as the recoverable database resource ID to restore.
/// RestoreLongTermRetentionBackup: Create a database by restoring from a long
/// term retention backup (longTermRetentionBackupResourceId required).
/// </summary>
public enum ManagedDatabaseCreateMode
{
    /// <summary>
    /// Default.
    /// </summary>
    Default,

    /// <summary>
    /// RestoreExternalBackup.
    /// </summary>
    RestoreExternalBackup,

    /// <summary>
    /// PointInTimeRestore.
    /// </summary>
    PointInTimeRestore,

    /// <summary>
    /// Recovery.
    /// </summary>
    Recovery,

    /// <summary>
    /// RestoreLongTermRetentionBackup.
    /// </summary>
    RestoreLongTermRetentionBackup,
}
