// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// A job target, for example a specific database or a container of databases
/// that is evaluated during job execution.
/// </summary>
public partial class JobTarget : ProvisionableConstruct
{
    /// <summary>
    /// Whether the target is included or excluded from the group.
    /// </summary>
    public BicepValue<JobTargetGroupMembershipType> MembershipType 
    {
        get { Initialize(); return _membershipType!; }
        set { Initialize(); _membershipType!.Assign(value); }
    }
    private BicepValue<JobTargetGroupMembershipType>? _membershipType;

    /// <summary>
    /// The target type.
    /// </summary>
    public BicepValue<JobTargetType> TargetType 
    {
        get { Initialize(); return _targetType!; }
        set { Initialize(); _targetType!.Assign(value); }
    }
    private BicepValue<JobTargetType>? _targetType;

    /// <summary>
    /// The target server name.
    /// </summary>
    public BicepValue<string> ServerName 
    {
        get { Initialize(); return _serverName!; }
        set { Initialize(); _serverName!.Assign(value); }
    }
    private BicepValue<string>? _serverName;

    /// <summary>
    /// The target database name.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
        set { Initialize(); _databaseName!.Assign(value); }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// The target elastic pool name.
    /// </summary>
    public BicepValue<string> ElasticPoolName 
    {
        get { Initialize(); return _elasticPoolName!; }
        set { Initialize(); _elasticPoolName!.Assign(value); }
    }
    private BicepValue<string>? _elasticPoolName;

    /// <summary>
    /// The target shard map.
    /// </summary>
    public BicepValue<string> ShardMapName 
    {
        get { Initialize(); return _shardMapName!; }
        set { Initialize(); _shardMapName!.Assign(value); }
    }
    private BicepValue<string>? _shardMapName;

    /// <summary>
    /// The resource ID of the credential that is used during job execution to
    /// connect to the target and determine the list of databases inside the
    /// target.
    /// </summary>
    public BicepValue<string> RefreshCredential 
    {
        get { Initialize(); return _refreshCredential!; }
        set { Initialize(); _refreshCredential!.Assign(value); }
    }
    private BicepValue<string>? _refreshCredential;

    /// <summary>
    /// Creates a new JobTarget.
    /// </summary>
    public JobTarget()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JobTarget.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _membershipType = DefineProperty<JobTargetGroupMembershipType>("MembershipType", ["membershipType"]);
        _targetType = DefineProperty<JobTargetType>("TargetType", ["type"]);
        _serverName = DefineProperty<string>("ServerName", ["serverName"]);
        _databaseName = DefineProperty<string>("DatabaseName", ["databaseName"]);
        _elasticPoolName = DefineProperty<string>("ElasticPoolName", ["elasticPoolName"]);
        _shardMapName = DefineProperty<string>("ShardMapName", ["shardMapName"]);
        _refreshCredential = DefineProperty<string>("RefreshCredential", ["refreshCredential"]);
    }
}
