// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The output configuration of a job step.
/// </summary>
public partial class JobStepOutput : ProvisionableConstruct
{
    /// <summary>
    /// The output destination type.
    /// </summary>
    public BicepValue<JobStepOutputType> OutputType 
    {
        get { Initialize(); return _outputType!; }
        set { Initialize(); _outputType!.Assign(value); }
    }
    private BicepValue<JobStepOutputType>? _outputType;

    /// <summary>
    /// The output destination subscription id.
    /// </summary>
    public BicepValue<Guid> SubscriptionId 
    {
        get { Initialize(); return _subscriptionId!; }
        set { Initialize(); _subscriptionId!.Assign(value); }
    }
    private BicepValue<Guid>? _subscriptionId;

    /// <summary>
    /// The output destination resource group.
    /// </summary>
    public BicepValue<string> ResourceGroupName 
    {
        get { Initialize(); return _resourceGroupName!; }
        set { Initialize(); _resourceGroupName!.Assign(value); }
    }
    private BicepValue<string>? _resourceGroupName;

    /// <summary>
    /// The output destination server name.
    /// </summary>
    public BicepValue<string> ServerName 
    {
        get { Initialize(); return _serverName!; }
        set { Initialize(); _serverName!.Assign(value); }
    }
    private BicepValue<string>? _serverName;

    /// <summary>
    /// The output destination database.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
        set { Initialize(); _databaseName!.Assign(value); }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// The output destination schema.
    /// </summary>
    public BicepValue<string> SchemaName 
    {
        get { Initialize(); return _schemaName!; }
        set { Initialize(); _schemaName!.Assign(value); }
    }
    private BicepValue<string>? _schemaName;

    /// <summary>
    /// The output destination table.
    /// </summary>
    public BicepValue<string> TableName 
    {
        get { Initialize(); return _tableName!; }
        set { Initialize(); _tableName!.Assign(value); }
    }
    private BicepValue<string>? _tableName;

    /// <summary>
    /// The resource ID of the credential to use to connect to the output
    /// destination.
    /// </summary>
    public BicepValue<string> Credential 
    {
        get { Initialize(); return _credential!; }
        set { Initialize(); _credential!.Assign(value); }
    }
    private BicepValue<string>? _credential;

    /// <summary>
    /// Creates a new JobStepOutput.
    /// </summary>
    public JobStepOutput()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JobStepOutput.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _outputType = DefineProperty<JobStepOutputType>("OutputType", ["type"]);
        _subscriptionId = DefineProperty<Guid>("SubscriptionId", ["subscriptionId"]);
        _resourceGroupName = DefineProperty<string>("ResourceGroupName", ["resourceGroupName"]);
        _serverName = DefineProperty<string>("ServerName", ["serverName"]);
        _databaseName = DefineProperty<string>("DatabaseName", ["databaseName"]);
        _schemaName = DefineProperty<string>("SchemaName", ["schemaName"]);
        _tableName = DefineProperty<string>("TableName", ["tableName"]);
        _credential = DefineProperty<string>("Credential", ["credential"]);
    }
}
