// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The action to be executed by a job step.
/// </summary>
public partial class JobStepAction : ProvisionableConstruct
{
    /// <summary>
    /// Type of action being executed by the job step.
    /// </summary>
    public BicepValue<JobStepActionType> ActionType 
    {
        get { Initialize(); return _actionType!; }
        set { Initialize(); _actionType!.Assign(value); }
    }
    private BicepValue<JobStepActionType>? _actionType;

    /// <summary>
    /// The source of the action to execute.
    /// </summary>
    public BicepValue<JobStepActionSource> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<JobStepActionSource>? _source;

    /// <summary>
    /// The action value, for example the text of the T-SQL script to execute.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Creates a new JobStepAction.
    /// </summary>
    public JobStepAction()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JobStepAction.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _actionType = DefineProperty<JobStepActionType>("ActionType", ["type"]);
        _source = DefineProperty<JobStepActionSource>("Source", ["source"]);
        _value = DefineProperty<string>("Value", ["value"]);
    }
}
