// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// The target that a job execution is executed on.
/// </summary>
public partial class JobExecutionTarget : ProvisionableConstruct
{
    /// <summary>
    /// The type of the target.
    /// </summary>
    public BicepValue<JobTargetType> TargetType 
    {
        get { Initialize(); return _targetType!; }
    }
    private BicepValue<JobTargetType>? _targetType;

    /// <summary>
    /// The server name.
    /// </summary>
    public BicepValue<string> ServerName 
    {
        get { Initialize(); return _serverName!; }
    }
    private BicepValue<string>? _serverName;

    /// <summary>
    /// The database name.
    /// </summary>
    public BicepValue<string> DatabaseName 
    {
        get { Initialize(); return _databaseName!; }
    }
    private BicepValue<string>? _databaseName;

    /// <summary>
    /// Creates a new JobExecutionTarget.
    /// </summary>
    public JobExecutionTarget()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JobExecutionTarget.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _targetType = DefineProperty<JobTargetType>("TargetType", ["type"], isOutput: true);
        _serverName = DefineProperty<string>("ServerName", ["serverName"], isOutput: true);
        _databaseName = DefineProperty<string>("DatabaseName", ["databaseName"], isOutput: true);
    }
}
