// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Per database settings of an elastic pool.
/// </summary>
public partial class ElasticPoolPerDatabaseSettings : ProvisionableConstruct
{
    /// <summary>
    /// The minimum capacity all databases are guaranteed.
    /// </summary>
    public BicepValue<double> MinCapacity 
    {
        get { Initialize(); return _minCapacity!; }
        set { Initialize(); _minCapacity!.Assign(value); }
    }
    private BicepValue<double>? _minCapacity;

    /// <summary>
    /// The maximum capacity any one database can consume.
    /// </summary>
    public BicepValue<double> MaxCapacity 
    {
        get { Initialize(); return _maxCapacity!; }
        set { Initialize(); _maxCapacity!.Assign(value); }
    }
    private BicepValue<double>? _maxCapacity;

    /// <summary>
    /// Creates a new ElasticPoolPerDatabaseSettings.
    /// </summary>
    public ElasticPoolPerDatabaseSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ElasticPoolPerDatabaseSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _minCapacity = DefineProperty<double>("MinCapacity", ["minCapacity"]);
        _maxCapacity = DefineProperty<double>("MaxCapacity", ["maxCapacity"]);
    }
}
