// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Properties for an Azure SQL Database Vulnerability Assessment rule
/// baseline&apos;s result.
/// </summary>
public partial class DatabaseVulnerabilityAssessmentRuleBaselineItem : ProvisionableConstruct
{
    /// <summary>
    /// The rule baseline result.
    /// </summary>
    public BicepList<string> Result 
    {
        get { Initialize(); return _result!; }
        set { Initialize(); _result!.Assign(value); }
    }
    private BicepList<string>? _result;

    /// <summary>
    /// Creates a new DatabaseVulnerabilityAssessmentRuleBaselineItem.
    /// </summary>
    public DatabaseVulnerabilityAssessmentRuleBaselineItem()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// DatabaseVulnerabilityAssessmentRuleBaselineItem.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _result = DefineListProperty<string>("Result", ["result"]);
    }
}
