// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// Azure Active Directory identity configuration for a resource.
/// </summary>
public partial class DatabaseIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The identity type.
    /// </summary>
    public BicepValue<DatabaseIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<DatabaseIdentityType>? _identityType;

    /// <summary>
    /// The Azure Active Directory tenant id.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// The resource ids of the user assigned identities to use.
    /// </summary>
    public BicepDictionary<UserAssignedIdentityDetails> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepDictionary<UserAssignedIdentityDetails>? _userAssignedIdentities;

    /// <summary>
    /// Creates a new DatabaseIdentity.
    /// </summary>
    public DatabaseIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DatabaseIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<DatabaseIdentityType>("IdentityType", ["type"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _userAssignedIdentities = DefineDictionaryProperty<UserAssignedIdentityDetails>("UserAssignedIdentities", ["userAssignedIdentities"]);
    }
}
