// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedServerDnsAlias.
/// </summary>
public partial class ManagedServerDnsAlias : ProvisionableResource
{
    /// <summary>
    /// The System.String to use.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Whether or not DNS record should be created for this alias.
    /// </summary>
    public BicepValue<bool> CreateDnsRecord 
    {
        get { Initialize(); return _createDnsRecord!; }
        set { Initialize(); _createDnsRecord!.Assign(value); }
    }
    private BicepValue<bool>? _createDnsRecord;

    /// <summary>
    /// The fully qualified DNS record for managed server alias.
    /// </summary>
    public BicepValue<string> AzureDnsRecord 
    {
        get { Initialize(); return _azureDnsRecord!; }
    }
    private BicepValue<string>? _azureDnsRecord;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The fully qualified public DNS record for managed server alias.
    /// </summary>
    public BicepValue<string> PublicAzureDnsRecord 
    {
        get { Initialize(); return _publicAzureDnsRecord!; }
    }
    private BicepValue<string>? _publicAzureDnsRecord;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new ManagedServerDnsAlias.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedServerDnsAlias resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedServerDnsAlias.</param>
    public ManagedServerDnsAlias(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/dnsAliases", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedServerDnsAlias.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _createDnsRecord = DefineProperty<bool>("CreateDnsRecord", ["createDnsRecord"]);
        _azureDnsRecord = DefineProperty<string>("AzureDnsRecord", ["properties", "azureDnsRecord"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _publicAzureDnsRecord = DefineProperty<string>("PublicAzureDnsRecord", ["properties", "publicAzureDnsRecord"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedServerDnsAlias resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedServerDnsAlias.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedServerDnsAlias resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedServerDnsAlias.</param>
    /// <returns>The existing ManagedServerDnsAlias resource.</returns>
    public static ManagedServerDnsAlias FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
