// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.
/// </summary>
public partial class ManagedRestorableDroppedDbBackupShortTermRetentionPolicy : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The backup retention period in days. This is how many days
    /// Point-in-Time Restore will be supported.
    /// </summary>
    public BicepValue<int> RetentionDays 
    {
        get { Initialize(); return _retentionDays!; }
        set { Initialize(); _retentionDays!.Assign(value); }
    }
    private BicepValue<int>? _retentionDays;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedRestorableDroppedDbBackupShortTermRetentionPolicy resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.</param>
    public ManagedRestorableDroppedDbBackupShortTermRetentionPolicy(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/restorableDroppedDatabases/backupShortTermRetentionPolicies", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _retentionDays = DefineProperty<int>("RetentionDays", ["properties", "retentionDays"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing
    /// ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedRestorableDroppedDbBackupShortTermRetentionPolicy resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedRestorableDroppedDbBackupShortTermRetentionPolicy.</param>
    /// <returns>The existing ManagedRestorableDroppedDbBackupShortTermRetentionPolicy resource.</returns>
    public static ManagedRestorableDroppedDbBackupShortTermRetentionPolicy FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
