// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedInstanceStartStopSchedule.
/// </summary>
public partial class ManagedInstanceStartStopSchedule : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The description of the schedule.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Schedule list.
    /// </summary>
    public BicepList<SqlScheduleItem> ScheduleList 
    {
        get { Initialize(); return _scheduleList!; }
        set { Initialize(); _scheduleList!.Assign(value); }
    }
    private BicepList<SqlScheduleItem>? _scheduleList;

    /// <summary>
    /// The time zone of the schedule.
    /// </summary>
    public BicepValue<string> TimeZoneId 
    {
        get { Initialize(); return _timeZoneId!; }
        set { Initialize(); _timeZoneId!.Assign(value); }
    }
    private BicepValue<string>? _timeZoneId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Timestamp when the next action will be executed in the corresponding
    /// schedule time zone.
    /// </summary>
    public BicepValue<string> NextExecutionTime 
    {
        get { Initialize(); return _nextExecutionTime!; }
    }
    private BicepValue<string>? _nextExecutionTime;

    /// <summary>
    /// Next action to be executed (Start or Stop).
    /// </summary>
    public BicepValue<string> NextRunAction 
    {
        get { Initialize(); return _nextRunAction!; }
    }
    private BicepValue<string>? _nextRunAction;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new ManagedInstanceStartStopSchedule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceStartStopSchedule
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceStartStopSchedule.</param>
    public ManagedInstanceStartStopSchedule(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/startStopSchedules", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedInstanceStartStopSchedule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _scheduleList = DefineListProperty<SqlScheduleItem>("ScheduleList", ["properties", "scheduleList"]);
        _timeZoneId = DefineProperty<string>("TimeZoneId", ["properties", "timeZoneId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _nextExecutionTime = DefineProperty<string>("NextExecutionTime", ["properties", "nextExecutionTime"], isOutput: true);
        _nextRunAction = DefineProperty<string>("NextRunAction", ["properties", "nextRunAction"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedInstanceStartStopSchedule resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedInstanceStartStopSchedule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceStartStopSchedule
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceStartStopSchedule.</param>
    /// <returns>The existing ManagedInstanceStartStopSchedule resource.</returns>
    public static ManagedInstanceStartStopSchedule FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
