// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedInstanceLongTermRetentionPolicy.
/// </summary>
public partial class ManagedInstanceLongTermRetentionPolicy : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The monthly retention policy for an LTR backup in an ISO 8601 format.
    /// </summary>
    public BicepValue<string> MonthlyRetention 
    {
        get { Initialize(); return _monthlyRetention!; }
        set { Initialize(); _monthlyRetention!.Assign(value); }
    }
    private BicepValue<string>? _monthlyRetention;

    /// <summary>
    /// The weekly retention policy for an LTR backup in an ISO 8601 format.
    /// </summary>
    public BicepValue<string> WeeklyRetention 
    {
        get { Initialize(); return _weeklyRetention!; }
        set { Initialize(); _weeklyRetention!.Assign(value); }
    }
    private BicepValue<string>? _weeklyRetention;

    /// <summary>
    /// The week of year to take the yearly backup in an ISO 8601 format.
    /// </summary>
    public BicepValue<int> WeekOfYear 
    {
        get { Initialize(); return _weekOfYear!; }
        set { Initialize(); _weekOfYear!.Assign(value); }
    }
    private BicepValue<int>? _weekOfYear;

    /// <summary>
    /// The yearly retention policy for an LTR backup in an ISO 8601 format.
    /// </summary>
    public BicepValue<string> YearlyRetention 
    {
        get { Initialize(); return _yearlyRetention!; }
        set { Initialize(); _yearlyRetention!.Assign(value); }
    }
    private BicepValue<string>? _yearlyRetention;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedDatabase.
    /// </summary>
    public ManagedDatabase? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedDatabase>? _parent;

    /// <summary>
    /// Creates a new ManagedInstanceLongTermRetentionPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedInstanceLongTermRetentionPolicy resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceLongTermRetentionPolicy.</param>
    public ManagedInstanceLongTermRetentionPolicy(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/databases/backupLongTermRetentionPolicies", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedInstanceLongTermRetentionPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _monthlyRetention = DefineProperty<string>("MonthlyRetention", ["properties", "monthlyRetention"]);
        _weeklyRetention = DefineProperty<string>("WeeklyRetention", ["properties", "weeklyRetention"]);
        _weekOfYear = DefineProperty<int>("WeekOfYear", ["properties", "weekOfYear"]);
        _yearlyRetention = DefineProperty<string>("YearlyRetention", ["properties", "yearlyRetention"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedDatabase>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedInstanceLongTermRetentionPolicy resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// ManagedInstanceLongTermRetentionPolicy.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedInstanceLongTermRetentionPolicy resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceLongTermRetentionPolicy.</param>
    /// <returns>The existing ManagedInstanceLongTermRetentionPolicy resource.</returns>
    public static ManagedInstanceLongTermRetentionPolicy FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
