// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedInstanceEncryptionProtector.
/// </summary>
public partial class ManagedInstanceEncryptionProtector : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Key auto rotation opt-in flag. Either true or false.
    /// </summary>
    public BicepValue<bool> IsAutoRotationEnabled 
    {
        get { Initialize(); return _isAutoRotationEnabled!; }
        set { Initialize(); _isAutoRotationEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoRotationEnabled;

    /// <summary>
    /// The name of the managed instance key.
    /// </summary>
    public BicepValue<string> ServerKeyName 
    {
        get { Initialize(); return _serverKeyName!; }
        set { Initialize(); _serverKeyName!.Assign(value); }
    }
    private BicepValue<string>? _serverKeyName;

    /// <summary>
    /// The encryption protector type like &apos;ServiceManaged&apos;,
    /// &apos;AzureKeyVault&apos;.
    /// </summary>
    public BicepValue<SqlServerKeyType> ServerKeyType 
    {
        get { Initialize(); return _serverKeyType!; }
        set { Initialize(); _serverKeyType!.Assign(value); }
    }
    private BicepValue<SqlServerKeyType>? _serverKeyType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Kind of encryption protector. This is metadata used for the Azure
    /// portal experience.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Thumbprint of the server key.
    /// </summary>
    public BicepValue<string> Thumbprint 
    {
        get { Initialize(); return _thumbprint!; }
    }
    private BicepValue<string>? _thumbprint;

    /// <summary>
    /// The URI of the server key.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new ManagedInstanceEncryptionProtector.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceEncryptionProtector
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceEncryptionProtector.</param>
    public ManagedInstanceEncryptionProtector(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/encryptionProtector", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedInstanceEncryptionProtector.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _isAutoRotationEnabled = DefineProperty<bool>("IsAutoRotationEnabled", ["properties", "autoRotationEnabled"]);
        _serverKeyName = DefineProperty<string>("ServerKeyName", ["properties", "serverKeyName"]);
        _serverKeyType = DefineProperty<SqlServerKeyType>("ServerKeyType", ["properties", "serverKeyType"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _thumbprint = DefineProperty<string>("Thumbprint", ["properties", "thumbprint"], isOutput: true);
        _uri = DefineProperty<Uri>("Uri", ["properties", "uri"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedInstanceEncryptionProtector resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedInstanceEncryptionProtector.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceEncryptionProtector
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceEncryptionProtector.</param>
    /// <returns>The existing ManagedInstanceEncryptionProtector resource.</returns>
    public static ManagedInstanceEncryptionProtector FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
