// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedInstanceAdministrator.
/// </summary>
public partial class ManagedInstanceAdministrator : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Type of the managed instance administrator.
    /// </summary>
    public BicepValue<ManagedInstanceAdministratorType> AdministratorType 
    {
        get { Initialize(); return _administratorType!; }
        set { Initialize(); _administratorType!.Assign(value); }
    }
    private BicepValue<ManagedInstanceAdministratorType>? _administratorType;

    /// <summary>
    /// Login name of the managed instance administrator.
    /// </summary>
    public BicepValue<string> Login 
    {
        get { Initialize(); return _login!; }
        set { Initialize(); _login!.Assign(value); }
    }
    private BicepValue<string>? _login;

    /// <summary>
    /// SID (object ID) of the managed instance administrator.
    /// </summary>
    public BicepValue<Guid> Sid 
    {
        get { Initialize(); return _sid!; }
        set { Initialize(); _sid!.Assign(value); }
    }
    private BicepValue<Guid>? _sid;

    /// <summary>
    /// Tenant ID of the managed instance administrator.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new ManagedInstanceAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceAdministrator
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceAdministrator.</param>
    public ManagedInstanceAdministrator(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/administrators", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedInstanceAdministrator.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _administratorType = DefineProperty<ManagedInstanceAdministratorType>("AdministratorType", ["properties", "administratorType"]);
        _login = DefineProperty<string>("Login", ["properties", "login"]);
        _sid = DefineProperty<Guid>("Sid", ["properties", "sid"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["properties", "tenantId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedInstanceAdministrator resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedInstanceAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstanceAdministrator
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstanceAdministrator.</param>
    /// <returns>The existing ManagedInstanceAdministrator resource.</returns>
    public static ManagedInstanceAdministrator FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
