// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedInstance.
/// </summary>
public partial class ManagedInstance : ProvisionableResource
{
    /// <summary>
    /// The name of the managed instance.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Administrator username for the managed instance. Can only be specified
    /// when the managed instance is being created (and is required for
    /// creation).
    /// </summary>
    public BicepValue<string> AdministratorLogin 
    {
        get { Initialize(); return _administratorLogin!; }
        set { Initialize(); _administratorLogin!.Assign(value); }
    }
    private BicepValue<string>? _administratorLogin;

    /// <summary>
    /// The administrator login password (required for managed instance
    /// creation).
    /// </summary>
    public BicepValue<string> AdministratorLoginPassword 
    {
        get { Initialize(); return _administratorLoginPassword!; }
        set { Initialize(); _administratorLoginPassword!.Assign(value); }
    }
    private BicepValue<string>? _administratorLoginPassword;

    /// <summary>
    /// The Azure Active Directory administrator of the instance. This can only
    /// be used at instance create time. If used for instance update, it will
    /// be ignored or it will result in an error. For updates individual APIs
    /// will need to be used.
    /// </summary>
    public ManagedInstanceExternalAdministrator Administrators 
    {
        get { Initialize(); return _administrators!; }
        set { Initialize(); AssignOrReplace(ref _administrators, value); }
    }
    private ManagedInstanceExternalAdministrator? _administrators;

    /// <summary>
    /// Collation of the managed instance.
    /// </summary>
    public BicepValue<string> Collation 
    {
        get { Initialize(); return _collation!; }
        set { Initialize(); _collation!.Assign(value); }
    }
    private BicepValue<string>? _collation;

    /// <summary>
    /// The Azure Active Directory identity of the managed instance.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The Id of the instance pool this managed server belongs to.
    /// </summary>
    public BicepValue<ResourceIdentifier> InstancePoolId 
    {
        get { Initialize(); return _instancePoolId!; }
        set { Initialize(); _instancePoolId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _instancePoolId;

    /// <summary>
    /// Whether or not the public data endpoint is enabled.
    /// </summary>
    public BicepValue<bool> IsPublicDataEndpointEnabled 
    {
        get { Initialize(); return _isPublicDataEndpointEnabled!; }
        set { Initialize(); _isPublicDataEndpointEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isPublicDataEndpointEnabled;

    /// <summary>
    /// Whether or not the multi-az is enabled.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// A CMK URI of the key to use for encryption.
    /// </summary>
    public BicepValue<Uri> KeyId 
    {
        get { Initialize(); return _keyId!; }
        set { Initialize(); _keyId!.Assign(value); }
    }
    private BicepValue<Uri>? _keyId;

    /// <summary>
    /// The license type. Possible values are &apos;LicenseIncluded&apos;
    /// (regular price inclusive of a new SQL license) and
    /// &apos;BasePrice&apos; (discounted AHB price for bringing your own SQL
    /// licenses).
    /// </summary>
    public BicepValue<ManagedInstanceLicenseType> LicenseType 
    {
        get { Initialize(); return _licenseType!; }
        set { Initialize(); _licenseType!.Assign(value); }
    }
    private BicepValue<ManagedInstanceLicenseType>? _licenseType;

    /// <summary>
    /// Specifies maintenance configuration id to apply to this managed
    /// instance.
    /// </summary>
    public BicepValue<ResourceIdentifier> MaintenanceConfigurationId 
    {
        get { Initialize(); return _maintenanceConfigurationId!; }
        set { Initialize(); _maintenanceConfigurationId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _maintenanceConfigurationId;

    /// <summary>
    /// The resource id of another managed instance whose DNS zone this managed
    /// instance will share after creation.
    /// </summary>
    public BicepValue<ResourceIdentifier> ManagedDnsZonePartner 
    {
        get { Initialize(); return _managedDnsZonePartner!; }
        set { Initialize(); _managedDnsZonePartner!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _managedDnsZonePartner;

    /// <summary>
    /// Specifies the mode of database creation.
    /// Default: Regular instance creation.
    /// Restore: Creates an instance by restoring a
    /// set of backups to specific point in time. RestorePointInTime and
    /// SourceManagedInstanceId must be specified.
    /// </summary>
    public BicepValue<ManagedServerCreateMode> ManagedInstanceCreateMode 
    {
        get { Initialize(); return _managedInstanceCreateMode!; }
        set { Initialize(); _managedInstanceCreateMode!.Assign(value); }
    }
    private BicepValue<ManagedServerCreateMode>? _managedInstanceCreateMode;

    /// <summary>
    /// Minimal TLS version. Allowed values: &apos;None&apos;, &apos;1.0&apos;,
    /// &apos;1.1&apos;, &apos;1.2&apos;.
    /// </summary>
    public BicepValue<string> MinimalTlsVersion 
    {
        get { Initialize(); return _minimalTlsVersion!; }
        set { Initialize(); _minimalTlsVersion!.Assign(value); }
    }
    private BicepValue<string>? _minimalTlsVersion;

    /// <summary>
    /// The resource id of a user assigned identity to be used by default.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrimaryUserAssignedIdentityId 
    {
        get { Initialize(); return _primaryUserAssignedIdentityId!; }
        set { Initialize(); _primaryUserAssignedIdentityId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _primaryUserAssignedIdentityId;

    /// <summary>
    /// Connection type used for connecting to the instance.
    /// </summary>
    public BicepValue<ManagedInstanceProxyOverride> ProxyOverride 
    {
        get { Initialize(); return _proxyOverride!; }
        set { Initialize(); _proxyOverride!.Assign(value); }
    }
    private BicepValue<ManagedInstanceProxyOverride>? _proxyOverride;

    /// <summary>
    /// The storage account type to be used to store backups for this instance.
    /// The options are Local (LocallyRedundantStorage), Zone
    /// (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
    /// GeoZone(GeoZoneRedundantStorage).
    /// </summary>
    public BicepValue<SqlBackupStorageRedundancy> RequestedBackupStorageRedundancy 
    {
        get { Initialize(); return _requestedBackupStorageRedundancy!; }
        set { Initialize(); _requestedBackupStorageRedundancy!.Assign(value); }
    }
    private BicepValue<SqlBackupStorageRedundancy>? _requestedBackupStorageRedundancy;

    /// <summary>
    /// Specifies the point in time (ISO8601 format) of the source database
    /// that will be restored to create the new database.
    /// </summary>
    public BicepValue<DateTimeOffset> RestorePointInTime 
    {
        get { Initialize(); return _restorePointInTime!; }
        set { Initialize(); _restorePointInTime!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _restorePointInTime;

    /// <summary>
    /// The managed instance&apos;s service principal.
    /// </summary>
    public SqlServicePrincipal ServicePrincipal 
    {
        get { Initialize(); return _servicePrincipal!; }
        set { Initialize(); AssignOrReplace(ref _servicePrincipal, value); }
    }
    private SqlServicePrincipal? _servicePrincipal;

    /// <summary>
    /// Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM,
    /// GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH.
    /// </summary>
    public SqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SqlSku? _sku;

    /// <summary>
    /// The resource identifier of the source managed instance associated with
    /// create operation of this instance.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceManagedInstanceId 
    {
        get { Initialize(); return _sourceManagedInstanceId!; }
        set { Initialize(); _sourceManagedInstanceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceManagedInstanceId;

    /// <summary>
    /// Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments
    /// of 32 GB allowed only. Maximum value depends on the selected hardware
    /// family and number of vCores.
    /// </summary>
    public BicepValue<int> StorageSizeInGB 
    {
        get { Initialize(); return _storageSizeInGB!; }
        set { Initialize(); _storageSizeInGB!.Assign(value); }
    }
    private BicepValue<int>? _storageSizeInGB;

    /// <summary>
    /// Subnet resource ID for the managed instance.
    /// </summary>
    public BicepValue<ResourceIdentifier> SubnetId 
    {
        get { Initialize(); return _subnetId!; }
        set { Initialize(); _subnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _subnetId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Id of the timezone. Allowed values are timezones supported by Windows.
    /// Windows keeps details on supported timezones, including
    /// the id, in registry under
    /// KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
    /// NT\CurrentVersion\Time Zones.             You can get those registry
    /// values via SQL Server by querying SELECT name AS timezone_id FROM
    /// sys.time_zone_info.             List of Ids can also be obtained by
    /// executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
    /// An example of valid timezone id is &quot;Pacific Standard
    /// Time&quot; or &quot;W. Europe Standard Time&quot;.
    /// </summary>
    public BicepValue<string> TimezoneId 
    {
        get { Initialize(); return _timezoneId!; }
        set { Initialize(); _timezoneId!.Assign(value); }
    }
    private BicepValue<string>? _timezoneId;

    /// <summary>
    /// The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
    /// </summary>
    public BicepValue<int> VCores 
    {
        get { Initialize(); return _vCores!; }
        set { Initialize(); _vCores!.Assign(value); }
    }
    private BicepValue<int>? _vCores;

    /// <summary>
    /// The storage account type used to store backups for this instance. The
    /// options are Local (LocallyRedundantStorage), Zone
    /// (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
    /// GeoZone(GeoZoneRedundantStorage).
    /// </summary>
    public BicepValue<SqlBackupStorageRedundancy> CurrentBackupStorageRedundancy 
    {
        get { Initialize(); return _currentBackupStorageRedundancy!; }
    }
    private BicepValue<SqlBackupStorageRedundancy>? _currentBackupStorageRedundancy;

    /// <summary>
    /// The Dns Zone that the managed instance is in.
    /// </summary>
    public BicepValue<string> DnsZone 
    {
        get { Initialize(); return _dnsZone!; }
    }
    private BicepValue<string>? _dnsZone;

    /// <summary>
    /// The fully qualified domain name of the managed instance.
    /// </summary>
    public BicepValue<string> FullyQualifiedDomainName 
    {
        get { Initialize(); return _fullyQualifiedDomainName!; }
    }
    private BicepValue<string>? _fullyQualifiedDomainName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// List of private endpoint connections on a managed instance.
    /// </summary>
    public BicepList<ManagedInstancePecProperty> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<ManagedInstancePecProperty>? _privateEndpointConnections;

    /// <summary>
    /// Gets the provisioning state.
    /// </summary>
    public BicepValue<ManagedInstancePropertiesProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ManagedInstancePropertiesProvisioningState>? _provisioningState;

    /// <summary>
    /// The state of the managed instance.
    /// </summary>
    public BicepValue<string> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<string>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ManagedInstance.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstance resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstance.</param>
    public ManagedInstance(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedInstance.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _administratorLogin = DefineProperty<string>("AdministratorLogin", ["properties", "administratorLogin"]);
        _administratorLoginPassword = DefineProperty<string>("AdministratorLoginPassword", ["properties", "administratorLoginPassword"]);
        _administrators = DefineModelProperty<ManagedInstanceExternalAdministrator>("Administrators", ["properties", "administrators"]);
        _collation = DefineProperty<string>("Collation", ["properties", "collation"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _instancePoolId = DefineProperty<ResourceIdentifier>("InstancePoolId", ["properties", "instancePoolId"]);
        _isPublicDataEndpointEnabled = DefineProperty<bool>("IsPublicDataEndpointEnabled", ["properties", "publicDataEndpointEnabled"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["properties", "zoneRedundant"]);
        _keyId = DefineProperty<Uri>("KeyId", ["properties", "keyId"]);
        _licenseType = DefineProperty<ManagedInstanceLicenseType>("LicenseType", ["properties", "licenseType"]);
        _maintenanceConfigurationId = DefineProperty<ResourceIdentifier>("MaintenanceConfigurationId", ["properties", "maintenanceConfigurationId"]);
        _managedDnsZonePartner = DefineProperty<ResourceIdentifier>("ManagedDnsZonePartner", ["properties", "dnsZonePartner"]);
        _managedInstanceCreateMode = DefineProperty<ManagedServerCreateMode>("ManagedInstanceCreateMode", ["properties", "managedInstanceCreateMode"]);
        _minimalTlsVersion = DefineProperty<string>("MinimalTlsVersion", ["properties", "minimalTlsVersion"]);
        _primaryUserAssignedIdentityId = DefineProperty<ResourceIdentifier>("PrimaryUserAssignedIdentityId", ["properties", "primaryUserAssignedIdentityId"]);
        _proxyOverride = DefineProperty<ManagedInstanceProxyOverride>("ProxyOverride", ["properties", "proxyOverride"]);
        _requestedBackupStorageRedundancy = DefineProperty<SqlBackupStorageRedundancy>("RequestedBackupStorageRedundancy", ["properties", "requestedBackupStorageRedundancy"]);
        _restorePointInTime = DefineProperty<DateTimeOffset>("RestorePointInTime", ["properties", "restorePointInTime"]);
        _servicePrincipal = DefineModelProperty<SqlServicePrincipal>("ServicePrincipal", ["properties", "servicePrincipal"]);
        _sku = DefineModelProperty<SqlSku>("Sku", ["sku"]);
        _sourceManagedInstanceId = DefineProperty<ResourceIdentifier>("SourceManagedInstanceId", ["properties", "sourceManagedInstanceId"]);
        _storageSizeInGB = DefineProperty<int>("StorageSizeInGB", ["properties", "storageSizeInGB"]);
        _subnetId = DefineProperty<ResourceIdentifier>("SubnetId", ["properties", "subnetId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _timezoneId = DefineProperty<string>("TimezoneId", ["properties", "timezoneId"]);
        _vCores = DefineProperty<int>("VCores", ["properties", "vCores"]);
        _currentBackupStorageRedundancy = DefineProperty<SqlBackupStorageRedundancy>("CurrentBackupStorageRedundancy", ["properties", "currentBackupStorageRedundancy"], isOutput: true);
        _dnsZone = DefineProperty<string>("DnsZone", ["properties", "dnsZone"], isOutput: true);
        _fullyQualifiedDomainName = DefineProperty<string>("FullyQualifiedDomainName", ["properties", "fullyQualifiedDomainName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<ManagedInstancePecProperty>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<ManagedInstancePropertiesProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _state = DefineProperty<string>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ManagedInstance resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedInstance.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedInstance resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedInstance.</param>
    /// <returns>The existing ManagedInstance resource.</returns>
    public static ManagedInstance FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ManagedInstance resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
