// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedDatabaseVulnerabilityAssessment.
/// </summary>
public partial class ManagedDatabaseVulnerabilityAssessment : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The recurring scans settings.
    /// </summary>
    public VulnerabilityAssessmentRecurringScansProperties RecurringScans 
    {
        get { Initialize(); return _recurringScans!; }
        set { Initialize(); AssignOrReplace(ref _recurringScans, value); }
    }
    private VulnerabilityAssessmentRecurringScansProperties? _recurringScans;

    /// <summary>
    /// Specifies the identifier key of the storage account for vulnerability
    /// assessment scan results. If &apos;StorageContainerSasKey&apos;
    /// isn&apos;t specified, storageAccountAccessKey is required.
    /// </summary>
    public BicepValue<string> StorageAccountAccessKey 
    {
        get { Initialize(); return _storageAccountAccessKey!; }
        set { Initialize(); _storageAccountAccessKey!.Assign(value); }
    }
    private BicepValue<string>? _storageAccountAccessKey;

    /// <summary>
    /// A blob storage container path to hold the scan results (e.g.
    /// https://myStorage.blob.core.windows.net/VaScans/).  It is required if
    /// server level vulnerability assessment policy doesn&apos;t set.
    /// </summary>
    public BicepValue<string> StorageContainerPath 
    {
        get { Initialize(); return _storageContainerPath!; }
        set { Initialize(); _storageContainerPath!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerPath;

    /// <summary>
    /// A shared access signature (SAS Key) that has write access to the blob
    /// container specified in &apos;storageContainerPath&apos; parameter. If
    /// &apos;storageAccountAccessKey&apos; isn&apos;t specified,
    /// StorageContainerSasKey is required.
    /// </summary>
    public BicepValue<string> StorageContainerSasKey 
    {
        get { Initialize(); return _storageContainerSasKey!; }
        set { Initialize(); _storageContainerSasKey!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerSasKey;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedDatabase.
    /// </summary>
    public ManagedDatabase? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedDatabase>? _parent;

    /// <summary>
    /// Creates a new ManagedDatabaseVulnerabilityAssessment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedDatabaseVulnerabilityAssessment resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedDatabaseVulnerabilityAssessment.</param>
    public ManagedDatabaseVulnerabilityAssessment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/databases/vulnerabilityAssessments", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedDatabaseVulnerabilityAssessment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _recurringScans = DefineModelProperty<VulnerabilityAssessmentRecurringScansProperties>("RecurringScans", ["properties", "recurringScans"]);
        _storageAccountAccessKey = DefineProperty<string>("StorageAccountAccessKey", ["properties", "storageAccountAccessKey"]);
        _storageContainerPath = DefineProperty<string>("StorageContainerPath", ["properties", "storageContainerPath"]);
        _storageContainerSasKey = DefineProperty<string>("StorageContainerSasKey", ["properties", "storageContainerSasKey"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedDatabase>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedDatabaseVulnerabilityAssessment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// ManagedDatabaseVulnerabilityAssessment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ManagedDatabaseVulnerabilityAssessment resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedDatabaseVulnerabilityAssessment.</param>
    /// <returns>The existing ManagedDatabaseVulnerabilityAssessment resource.</returns>
    public static ManagedDatabaseVulnerabilityAssessment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
