// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ManagedDatabase.
/// </summary>
public partial class ManagedDatabase : ProvisionableResource
{
    /// <summary>
    /// The name of the database.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Whether to auto complete restore of this managed database.
    /// </summary>
    public BicepValue<bool> AllowAutoCompleteRestore 
    {
        get { Initialize(); return _allowAutoCompleteRestore!; }
        set { Initialize(); _allowAutoCompleteRestore!.Assign(value); }
    }
    private BicepValue<bool>? _allowAutoCompleteRestore;

    /// <summary>
    /// Collation of the metadata catalog.
    /// </summary>
    public BicepValue<CatalogCollationType> CatalogCollation 
    {
        get { Initialize(); return _catalogCollation!; }
        set { Initialize(); _catalogCollation!.Assign(value); }
    }
    private BicepValue<CatalogCollationType>? _catalogCollation;

    /// <summary>
    /// Collation of the managed database.
    /// </summary>
    public BicepValue<string> Collation 
    {
        get { Initialize(); return _collation!; }
        set { Initialize(); _collation!.Assign(value); }
    }
    private BicepValue<string>? _collation;

    /// <summary>
    /// Managed database create mode. PointInTimeRestore: Create a database by
    /// restoring a point in time backup of an existing database.
    /// SourceDatabaseName, SourceManagedInstanceName and PointInTime must be
    /// specified. RestoreExternalBackup: Create a database by restoring from
    /// external backup files. Collation, StorageContainerUri and
    /// StorageContainerSasToken must be specified. Recovery: Creates a
    /// database by restoring a geo-replicated backup. RecoverableDatabaseId
    /// must be specified as the recoverable database resource ID to restore.
    /// RestoreLongTermRetentionBackup: Create a database by restoring from a
    /// long term retention backup (longTermRetentionBackupResourceId
    /// required).
    /// </summary>
    public BicepValue<ManagedDatabaseCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<ManagedDatabaseCreateMode>? _createMode;

    /// <summary>
    /// The restorable cross-subscription dropped database resource id to
    /// restore when creating this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> CrossSubscriptionRestorableDroppedDatabaseId 
    {
        get { Initialize(); return _crossSubscriptionRestorableDroppedDatabaseId!; }
        set { Initialize(); _crossSubscriptionRestorableDroppedDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _crossSubscriptionRestorableDroppedDatabaseId;

    /// <summary>
    /// The resource identifier of the cross-subscription source database
    /// associated with create operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> CrossSubscriptionSourceDatabaseId 
    {
        get { Initialize(); return _crossSubscriptionSourceDatabaseId!; }
        set { Initialize(); _crossSubscriptionSourceDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _crossSubscriptionSourceDatabaseId;

    /// <summary>
    /// Target managed instance id used in cross-subscription restore.
    /// </summary>
    public BicepValue<ResourceIdentifier> CrossSubscriptionTargetManagedInstanceId 
    {
        get { Initialize(); return _crossSubscriptionTargetManagedInstanceId!; }
        set { Initialize(); _crossSubscriptionTargetManagedInstanceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _crossSubscriptionTargetManagedInstanceId;

    /// <summary>
    /// Whether or not this database is a ledger database, which means all
    /// tables in the database are ledger tables. Note: the value of this
    /// property cannot be changed after the database has been created.
    /// </summary>
    public BicepValue<bool> IsLedgerOn 
    {
        get { Initialize(); return _isLedgerOn!; }
        set { Initialize(); _isLedgerOn!.Assign(value); }
    }
    private BicepValue<bool>? _isLedgerOn;

    /// <summary>
    /// Last backup file name for restore of this managed database.
    /// </summary>
    public BicepValue<string> LastBackupName 
    {
        get { Initialize(); return _lastBackupName!; }
        set { Initialize(); _lastBackupName!.Assign(value); }
    }
    private BicepValue<string>? _lastBackupName;

    /// <summary>
    /// The name of the Long Term Retention backup to be used for restore of
    /// this managed database.
    /// </summary>
    public BicepValue<ResourceIdentifier> LongTermRetentionBackupResourceId 
    {
        get { Initialize(); return _longTermRetentionBackupResourceId!; }
        set { Initialize(); _longTermRetentionBackupResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _longTermRetentionBackupResourceId;

    /// <summary>
    /// The resource identifier of the recoverable database associated with
    /// create operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> RecoverableDatabaseId 
    {
        get { Initialize(); return _recoverableDatabaseId!; }
        set { Initialize(); _recoverableDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _recoverableDatabaseId;

    /// <summary>
    /// The restorable dropped database resource id to restore when creating
    /// this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> RestorableDroppedDatabaseId 
    {
        get { Initialize(); return _restorableDroppedDatabaseId!; }
        set { Initialize(); _restorableDroppedDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _restorableDroppedDatabaseId;

    /// <summary>
    /// Conditional. If createMode is PointInTimeRestore, this value is
    /// required. Specifies the point in time (ISO8601 format) of the source
    /// database that will be restored to create the new database.
    /// </summary>
    public BicepValue<DateTimeOffset> RestorePointInTime 
    {
        get { Initialize(); return _restorePointInTime!; }
        set { Initialize(); _restorePointInTime!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _restorePointInTime;

    /// <summary>
    /// The resource identifier of the source database associated with create
    /// operation of this database.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceDatabaseId 
    {
        get { Initialize(); return _sourceDatabaseId!; }
        set { Initialize(); _sourceDatabaseId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceDatabaseId;

    /// <summary>
    /// Conditional. If createMode is RestoreExternalBackup, this value is
    /// used. Specifies the identity used for storage container
    /// authentication. Can be &apos;SharedAccessSignature&apos; or
    /// &apos;ManagedIdentity&apos;; if not specified
    /// &apos;SharedAccessSignature&apos; is assumed.
    /// </summary>
    public BicepValue<string> StorageContainerIdentity 
    {
        get { Initialize(); return _storageContainerIdentity!; }
        set { Initialize(); _storageContainerIdentity!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerIdentity;

    /// <summary>
    /// Conditional. If createMode is RestoreExternalBackup and
    /// storageContainerIdentity is not ManagedIdentity, this value is
    /// required. Specifies the storage container sas token.
    /// </summary>
    public BicepValue<string> StorageContainerSasToken 
    {
        get { Initialize(); return _storageContainerSasToken!; }
        set { Initialize(); _storageContainerSasToken!.Assign(value); }
    }
    private BicepValue<string>? _storageContainerSasToken;

    /// <summary>
    /// Conditional. If createMode is RestoreExternalBackup, this value is
    /// required. Specifies the uri of the storage container where backups for
    /// this restore are stored.
    /// </summary>
    public BicepValue<Uri> StorageContainerUri 
    {
        get { Initialize(); return _storageContainerUri!; }
        set { Initialize(); _storageContainerUri!.Assign(value); }
    }
    private BicepValue<Uri>? _storageContainerUri;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Creation date of the database.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Geo paired region.
    /// </summary>
    public BicepValue<AzureLocation> DefaultSecondaryLocation 
    {
        get { Initialize(); return _defaultSecondaryLocation!; }
    }
    private BicepValue<AzureLocation>? _defaultSecondaryLocation;

    /// <summary>
    /// Earliest restore point in time for point in time restore.
    /// </summary>
    public BicepValue<DateTimeOffset> EarliestRestorePoint 
    {
        get { Initialize(); return _earliestRestorePoint!; }
    }
    private BicepValue<DateTimeOffset>? _earliestRestorePoint;

    /// <summary>
    /// Instance Failover Group resource identifier that this managed database
    /// belongs to.
    /// </summary>
    public BicepValue<ResourceIdentifier> FailoverGroupId 
    {
        get { Initialize(); return _failoverGroupId!; }
    }
    private BicepValue<ResourceIdentifier>? _failoverGroupId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Status of the database.
    /// </summary>
    public BicepValue<ManagedDatabaseStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<ManagedDatabaseStatus>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new ManagedDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedDatabase resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedDatabase.</param>
    public ManagedDatabase(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/databases", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedDatabase.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _allowAutoCompleteRestore = DefineProperty<bool>("AllowAutoCompleteRestore", ["properties", "autoCompleteRestore"]);
        _catalogCollation = DefineProperty<CatalogCollationType>("CatalogCollation", ["properties", "catalogCollation"]);
        _collation = DefineProperty<string>("Collation", ["properties", "collation"]);
        _createMode = DefineProperty<ManagedDatabaseCreateMode>("CreateMode", ["properties", "createMode"]);
        _crossSubscriptionRestorableDroppedDatabaseId = DefineProperty<ResourceIdentifier>("CrossSubscriptionRestorableDroppedDatabaseId", ["properties", "crossSubscriptionRestorableDroppedDatabaseId"]);
        _crossSubscriptionSourceDatabaseId = DefineProperty<ResourceIdentifier>("CrossSubscriptionSourceDatabaseId", ["properties", "crossSubscriptionSourceDatabaseId"]);
        _crossSubscriptionTargetManagedInstanceId = DefineProperty<ResourceIdentifier>("CrossSubscriptionTargetManagedInstanceId", ["properties", "crossSubscriptionTargetManagedInstanceId"]);
        _isLedgerOn = DefineProperty<bool>("IsLedgerOn", ["properties", "isLedgerOn"]);
        _lastBackupName = DefineProperty<string>("LastBackupName", ["properties", "lastBackupName"]);
        _longTermRetentionBackupResourceId = DefineProperty<ResourceIdentifier>("LongTermRetentionBackupResourceId", ["properties", "longTermRetentionBackupResourceId"]);
        _recoverableDatabaseId = DefineProperty<ResourceIdentifier>("RecoverableDatabaseId", ["properties", "recoverableDatabaseId"]);
        _restorableDroppedDatabaseId = DefineProperty<ResourceIdentifier>("RestorableDroppedDatabaseId", ["properties", "restorableDroppedDatabaseId"]);
        _restorePointInTime = DefineProperty<DateTimeOffset>("RestorePointInTime", ["properties", "restorePointInTime"]);
        _sourceDatabaseId = DefineProperty<ResourceIdentifier>("SourceDatabaseId", ["properties", "sourceDatabaseId"]);
        _storageContainerIdentity = DefineProperty<string>("StorageContainerIdentity", ["properties", "storageContainerIdentity"]);
        _storageContainerSasToken = DefineProperty<string>("StorageContainerSasToken", ["properties", "storageContainerSasToken"]);
        _storageContainerUri = DefineProperty<Uri>("StorageContainerUri", ["properties", "storageContainerUri"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _defaultSecondaryLocation = DefineProperty<AzureLocation>("DefaultSecondaryLocation", ["properties", "defaultSecondaryLocation"], isOutput: true);
        _earliestRestorePoint = DefineProperty<DateTimeOffset>("EarliestRestorePoint", ["properties", "earliestRestorePoint"], isOutput: true);
        _failoverGroupId = DefineProperty<ResourceIdentifier>("FailoverGroupId", ["properties", "failoverGroupId"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _status = DefineProperty<ManagedDatabaseStatus>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagedDatabase resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagedDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagedDatabase resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagedDatabase.</param>
    /// <returns>The existing ManagedDatabase resource.</returns>
    public static ManagedDatabase FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
