// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// InstancePool.
/// </summary>
public partial class InstancePool : ProvisionableResource
{
    /// <summary>
    /// The name of the instance pool to be created or updated.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The license type. Possible values are &apos;LicenseIncluded&apos;
    /// (price for SQL license is included) and &apos;BasePrice&apos; (without
    /// SQL license price).
    /// </summary>
    public BicepValue<InstancePoolLicenseType> LicenseType 
    {
        get { Initialize(); return _licenseType!; }
        set { Initialize(); _licenseType!.Assign(value); }
    }
    private BicepValue<InstancePoolLicenseType>? _licenseType;

    /// <summary>
    /// Specifies maintenance configuration id to apply to this managed
    /// instance.
    /// </summary>
    public BicepValue<ResourceIdentifier> MaintenanceConfigurationId 
    {
        get { Initialize(); return _maintenanceConfigurationId!; }
        set { Initialize(); _maintenanceConfigurationId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _maintenanceConfigurationId;

    /// <summary>
    /// The name and tier of the SKU.
    /// </summary>
    public SqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SqlSku? _sku;

    /// <summary>
    /// Resource ID of the subnet to place this instance pool in.
    /// </summary>
    public BicepValue<ResourceIdentifier> SubnetId 
    {
        get { Initialize(); return _subnetId!; }
        set { Initialize(); _subnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _subnetId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Count of vCores belonging to this instance pool.
    /// </summary>
    public BicepValue<int> VCores 
    {
        get { Initialize(); return _vCores!; }
        set { Initialize(); _vCores!.Assign(value); }
    }
    private BicepValue<int>? _vCores;

    /// <summary>
    /// The Dns Zone that the managed instance pool is in.
    /// </summary>
    public BicepValue<string> DnsZone 
    {
        get { Initialize(); return _dnsZone!; }
    }
    private BicepValue<string>? _dnsZone;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new InstancePool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the InstancePool resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the InstancePool.</param>
    public InstancePool(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/instancePools", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of InstancePool.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _licenseType = DefineProperty<InstancePoolLicenseType>("LicenseType", ["properties", "licenseType"]);
        _maintenanceConfigurationId = DefineProperty<ResourceIdentifier>("MaintenanceConfigurationId", ["properties", "maintenanceConfigurationId"]);
        _sku = DefineModelProperty<SqlSku>("Sku", ["sku"]);
        _subnetId = DefineProperty<ResourceIdentifier>("SubnetId", ["properties", "subnetId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _vCores = DefineProperty<int>("VCores", ["properties", "vCores"]);
        _dnsZone = DefineProperty<string>("DnsZone", ["properties", "dnsZone"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported InstancePool resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing InstancePool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the InstancePool resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the InstancePool.</param>
    /// <returns>The existing InstancePool resource.</returns>
    public static InstancePool FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
