// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// InstanceFailoverGroup.
/// </summary>
public partial class InstanceFailoverGroup : ProvisionableResource
{
    /// <summary>
    /// The name of the failover group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// List of managed instance pairs in the failover group.
    /// </summary>
    public BicepList<ManagedInstancePairInfo> ManagedInstancePairs 
    {
        get { Initialize(); return _managedInstancePairs!; }
        set { Initialize(); _managedInstancePairs!.Assign(value); }
    }
    private BicepList<ManagedInstancePairInfo>? _managedInstancePairs;

    /// <summary>
    /// Partner region information for the failover group.
    /// </summary>
    public BicepList<PartnerRegionInfo> PartnerRegions 
    {
        get { Initialize(); return _partnerRegions!; }
        set { Initialize(); _partnerRegions!.Assign(value); }
    }
    private BicepList<PartnerRegionInfo>? _partnerRegions;

    /// <summary>
    /// Failover policy of the read-only endpoint for the failover group.
    /// </summary>
    public BicepValue<ReadOnlyEndpointFailoverPolicy> ReadOnlyEndpointFailoverPolicy 
    {
        get { Initialize(); return _readOnlyEndpointFailoverPolicy!; }
        set { Initialize(); _readOnlyEndpointFailoverPolicy!.Assign(value); }
    }
    private BicepValue<ReadOnlyEndpointFailoverPolicy>? _readOnlyEndpointFailoverPolicy;

    /// <summary>
    /// Read-write endpoint of the failover group instance.
    /// </summary>
    public InstanceFailoverGroupReadWriteEndpoint ReadWriteEndpoint 
    {
        get { Initialize(); return _readWriteEndpoint!; }
        set { Initialize(); AssignOrReplace(ref _readWriteEndpoint, value); }
    }
    private InstanceFailoverGroupReadWriteEndpoint? _readWriteEndpoint;

    /// <summary>
    /// Type of the geo-secondary instance. Set &apos;Standby&apos; if the
    /// instance is used as a DR option only.
    /// </summary>
    public BicepValue<GeoSecondaryInstanceType> SecondaryType 
    {
        get { Initialize(); return _secondaryType!; }
        set { Initialize(); _secondaryType!.Assign(value); }
    }
    private BicepValue<GeoSecondaryInstanceType>? _secondaryType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Local replication role of the failover group instance.
    /// </summary>
    public BicepValue<InstanceFailoverGroupReplicationRole> ReplicationRole 
    {
        get { Initialize(); return _replicationRole!; }
    }
    private BicepValue<InstanceFailoverGroupReplicationRole>? _replicationRole;

    /// <summary>
    /// Replication state of the failover group instance.
    /// </summary>
    public BicepValue<string> ReplicationState 
    {
        get { Initialize(); return _replicationState!; }
    }
    private BicepValue<string>? _replicationState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new InstanceFailoverGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the InstanceFailoverGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the InstanceFailoverGroup.</param>
    public InstanceFailoverGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/locations/instanceFailoverGroups", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of InstanceFailoverGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _managedInstancePairs = DefineListProperty<ManagedInstancePairInfo>("ManagedInstancePairs", ["properties", "managedInstancePairs"]);
        _partnerRegions = DefineListProperty<PartnerRegionInfo>("PartnerRegions", ["properties", "partnerRegions"]);
        _readOnlyEndpointFailoverPolicy = DefineProperty<ReadOnlyEndpointFailoverPolicy>("ReadOnlyEndpointFailoverPolicy", ["properties", "readOnlyEndpoint", "failoverPolicy"]);
        _readWriteEndpoint = DefineModelProperty<InstanceFailoverGroupReadWriteEndpoint>("ReadWriteEndpoint", ["properties", "readWriteEndpoint"]);
        _secondaryType = DefineProperty<GeoSecondaryInstanceType>("SecondaryType", ["properties", "secondaryType"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _replicationRole = DefineProperty<InstanceFailoverGroupReplicationRole>("ReplicationRole", ["properties", "replicationRole"], isOutput: true);
        _replicationState = DefineProperty<string>("ReplicationState", ["properties", "replicationState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported InstanceFailoverGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing InstanceFailoverGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the InstanceFailoverGroup resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the InstanceFailoverGroup.</param>
    /// <returns>The existing InstanceFailoverGroup resource.</returns>
    public static InstanceFailoverGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
