// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// IPv6FirewallRule.
/// </summary>
public partial class IPv6FirewallRule : ProvisionableResource
{
    /// <summary>
    /// The name of the firewall rule.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The end IP address of the firewall rule. Must be IPv6 format. Must be
    /// greater than or equal to startIpv6Address.
    /// </summary>
    public BicepValue<string> EndIPv6Address 
    {
        get { Initialize(); return _endIPv6Address!; }
        set { Initialize(); _endIPv6Address!.Assign(value); }
    }
    private BicepValue<string>? _endIPv6Address;

    /// <summary>
    /// The start IP address of the firewall rule. Must be IPv6 format.
    /// </summary>
    public BicepValue<string> StartIPv6Address 
    {
        get { Initialize(); return _startIPv6Address!; }
        set { Initialize(); _startIPv6Address!.Assign(value); }
    }
    private BicepValue<string>? _startIPv6Address;

    /// <summary>
    /// Resource ID.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new IPv6FirewallRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the IPv6FirewallRule resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the IPv6FirewallRule.</param>
    public IPv6FirewallRule(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/ipv6FirewallRules", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of IPv6FirewallRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _endIPv6Address = DefineProperty<string>("EndIPv6Address", ["properties", "endIPv6Address"]);
        _startIPv6Address = DefineProperty<string>("StartIPv6Address", ["properties", "startIPv6Address"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported IPv6FirewallRule resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing IPv6FirewallRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the IPv6FirewallRule resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the IPv6FirewallRule.</param>
    /// <returns>The existing IPv6FirewallRule resource.</returns>
    public static IPv6FirewallRule FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
