// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// FailoverGroup.
/// </summary>
public partial class FailoverGroup : ProvisionableResource
{
    /// <summary>
    /// The name of the failover group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// List of databases in the failover group.
    /// </summary>
    public BicepList<ResourceIdentifier> FailoverDatabases 
    {
        get { Initialize(); return _failoverDatabases!; }
        set { Initialize(); _failoverDatabases!.Assign(value); }
    }
    private BicepList<ResourceIdentifier>? _failoverDatabases;

    /// <summary>
    /// List of partner server information for the failover group.
    /// </summary>
    public BicepList<PartnerServerInfo> PartnerServers 
    {
        get { Initialize(); return _partnerServers!; }
        set { Initialize(); _partnerServers!.Assign(value); }
    }
    private BicepList<PartnerServerInfo>? _partnerServers;

    /// <summary>
    /// Read-only endpoint of the failover group instance.
    /// </summary>
    public FailoverGroupReadOnlyEndpoint ReadOnlyEndpoint 
    {
        get { Initialize(); return _readOnlyEndpoint!; }
        set { Initialize(); AssignOrReplace(ref _readOnlyEndpoint, value); }
    }
    private FailoverGroupReadOnlyEndpoint? _readOnlyEndpoint;

    /// <summary>
    /// Read-write endpoint of the failover group instance.
    /// </summary>
    public FailoverGroupReadWriteEndpoint ReadWriteEndpoint 
    {
        get { Initialize(); return _readWriteEndpoint!; }
        set { Initialize(); AssignOrReplace(ref _readWriteEndpoint, value); }
    }
    private FailoverGroupReadWriteEndpoint? _readWriteEndpoint;

    /// <summary>
    /// Resource tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Resource location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Local replication role of the failover group instance.
    /// </summary>
    public BicepValue<FailoverGroupReplicationRole> ReplicationRole 
    {
        get { Initialize(); return _replicationRole!; }
    }
    private BicepValue<FailoverGroupReplicationRole>? _replicationRole;

    /// <summary>
    /// Replication state of the failover group instance.
    /// </summary>
    public BicepValue<string> ReplicationState 
    {
        get { Initialize(); return _replicationState!; }
    }
    private BicepValue<string>? _replicationState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new FailoverGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FailoverGroup resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FailoverGroup.</param>
    public FailoverGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/failoverGroups", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FailoverGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _failoverDatabases = DefineListProperty<ResourceIdentifier>("FailoverDatabases", ["properties", "databases"]);
        _partnerServers = DefineListProperty<PartnerServerInfo>("PartnerServers", ["properties", "partnerServers"]);
        _readOnlyEndpoint = DefineModelProperty<FailoverGroupReadOnlyEndpoint>("ReadOnlyEndpoint", ["properties", "readOnlyEndpoint"]);
        _readWriteEndpoint = DefineModelProperty<FailoverGroupReadWriteEndpoint>("ReadWriteEndpoint", ["properties", "readWriteEndpoint"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _replicationRole = DefineProperty<FailoverGroupReplicationRole>("ReplicationRole", ["properties", "replicationRole"], isOutput: true);
        _replicationState = DefineProperty<string>("ReplicationState", ["properties", "replicationState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported FailoverGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing FailoverGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FailoverGroup resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FailoverGroup.</param>
    /// <returns>The existing FailoverGroup resource.</returns>
    public static FailoverGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this FailoverGroup resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
