// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Sql;

/// <summary>
/// ElasticPool.
/// </summary>
public partial class ElasticPool : ProvisionableResource
{
    /// <summary>
    /// The name of the elastic pool.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Specifies the availability zone the pool&apos;s primary replica is
    /// pinned to.
    /// </summary>
    public BicepValue<SqlAvailabilityZoneType> AvailabilityZone 
    {
        get { Initialize(); return _availabilityZone!; }
        set { Initialize(); _availabilityZone!.Assign(value); }
    }
    private BicepValue<SqlAvailabilityZoneType>? _availabilityZone;

    /// <summary>
    /// The number of secondary replicas associated with the elastic pool that
    /// are used to provide high availability. Applicable only to Hyperscale
    /// elastic pools.
    /// </summary>
    public BicepValue<int> HighAvailabilityReplicaCount 
    {
        get { Initialize(); return _highAvailabilityReplicaCount!; }
        set { Initialize(); _highAvailabilityReplicaCount!.Assign(value); }
    }
    private BicepValue<int>? _highAvailabilityReplicaCount;

    /// <summary>
    /// Whether or not this elastic pool is zone redundant, which means the
    /// replicas of this elastic pool will be spread across multiple
    /// availability zones.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// The license type to apply for this elastic pool.
    /// </summary>
    public BicepValue<ElasticPoolLicenseType> LicenseType 
    {
        get { Initialize(); return _licenseType!; }
        set { Initialize(); _licenseType!.Assign(value); }
    }
    private BicepValue<ElasticPoolLicenseType>? _licenseType;

    /// <summary>
    /// Maintenance configuration id assigned to the elastic pool. This
    /// configuration defines the period when the maintenance updates will
    /// will occur.
    /// </summary>
    public BicepValue<ResourceIdentifier> MaintenanceConfigurationId 
    {
        get { Initialize(); return _maintenanceConfigurationId!; }
        set { Initialize(); _maintenanceConfigurationId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _maintenanceConfigurationId;

    /// <summary>
    /// The storage limit for the database elastic pool in bytes.
    /// </summary>
    public BicepValue<long> MaxSizeBytes 
    {
        get { Initialize(); return _maxSizeBytes!; }
        set { Initialize(); _maxSizeBytes!.Assign(value); }
    }
    private BicepValue<long>? _maxSizeBytes;

    /// <summary>
    /// Minimal capacity that serverless pool will not shrink below, if not
    /// paused.
    /// </summary>
    public BicepValue<double> MinCapacity 
    {
        get { Initialize(); return _minCapacity!; }
        set { Initialize(); _minCapacity!.Assign(value); }
    }
    private BicepValue<double>? _minCapacity;

    /// <summary>
    /// The per database settings for the elastic pool.
    /// </summary>
    public ElasticPoolPerDatabaseSettings PerDatabaseSettings 
    {
        get { Initialize(); return _perDatabaseSettings!; }
        set { Initialize(); AssignOrReplace(ref _perDatabaseSettings, value); }
    }
    private ElasticPoolPerDatabaseSettings? _perDatabaseSettings;

    /// <summary>
    /// Type of enclave requested on the elastic pool.
    /// </summary>
    public BicepValue<SqlAlwaysEncryptedEnclaveType> PreferredEnclaveType 
    {
        get { Initialize(); return _preferredEnclaveType!; }
        set { Initialize(); _preferredEnclaveType!.Assign(value); }
    }
    private BicepValue<SqlAlwaysEncryptedEnclaveType>? _preferredEnclaveType;

    /// <summary>
    /// The elastic pool SKU.                           The list of SKUs may
    /// vary by region and support offer. To determine the SKUs (including the
    /// SKU name, tier/edition, family, and capacity) that are available to
    /// your subscription in an Azure region, use the
    /// `Capabilities_ListByLocation` REST API or the following command:
    /// ```azurecli              az sql elastic-pool
    /// list-editions -l &lt;location&gt; -o table              ````
    /// </summary>
    public SqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SqlSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The creation date of the elastic pool (ISO8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Kind of elastic pool. This is metadata used for the Azure portal
    /// experience.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The state of the elastic pool.
    /// </summary>
    public BicepValue<ElasticPoolState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<ElasticPoolState>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent SqlServer.
    /// </summary>
    public SqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<SqlServer>? _parent;

    /// <summary>
    /// Creates a new ElasticPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ElasticPool resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ElasticPool.</param>
    public ElasticPool(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/servers/elasticPools", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ElasticPool.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _availabilityZone = DefineProperty<SqlAvailabilityZoneType>("AvailabilityZone", ["properties", "availabilityZone"]);
        _highAvailabilityReplicaCount = DefineProperty<int>("HighAvailabilityReplicaCount", ["properties", "highAvailabilityReplicaCount"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["properties", "zoneRedundant"]);
        _licenseType = DefineProperty<ElasticPoolLicenseType>("LicenseType", ["properties", "licenseType"]);
        _maintenanceConfigurationId = DefineProperty<ResourceIdentifier>("MaintenanceConfigurationId", ["properties", "maintenanceConfigurationId"]);
        _maxSizeBytes = DefineProperty<long>("MaxSizeBytes", ["properties", "maxSizeBytes"]);
        _minCapacity = DefineProperty<double>("MinCapacity", ["properties", "minCapacity"]);
        _perDatabaseSettings = DefineModelProperty<ElasticPoolPerDatabaseSettings>("PerDatabaseSettings", ["properties", "perDatabaseSettings"]);
        _preferredEnclaveType = DefineProperty<SqlAlwaysEncryptedEnclaveType>("PreferredEnclaveType", ["properties", "preferredEnclaveType"]);
        _sku = DefineModelProperty<SqlSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _state = DefineProperty<ElasticPoolState>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<SqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ElasticPool resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";

        /// <summary>
        /// 2014-01-01.
        /// </summary>
        public static readonly string V2014_01_01 = "2014-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing ElasticPool.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ElasticPool resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ElasticPool.</param>
    /// <returns>The existing ElasticPool resource.</returns>
    public static ElasticPool FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ElasticPool resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 128, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period | ResourceNameCharacters.Parentheses);
}
