// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Sql;

/// <summary>
/// DistributedAvailabilityGroup.
/// </summary>
public partial class DistributedAvailabilityGroup : ProvisionableResource
{
    /// <summary>
    /// The distributed availability group name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The primary availability group name.
    /// </summary>
    public BicepValue<string> PrimaryAvailabilityGroupName 
    {
        get { Initialize(); return _primaryAvailabilityGroupName!; }
        set { Initialize(); _primaryAvailabilityGroupName!.Assign(value); }
    }
    private BicepValue<string>? _primaryAvailabilityGroupName;

    /// <summary>
    /// The replication mode of a distributed availability group. Parameter
    /// will be ignored during link creation.
    /// </summary>
    public BicepValue<DistributedAvailabilityGroupReplicationMode> ReplicationMode 
    {
        get { Initialize(); return _replicationMode!; }
        set { Initialize(); _replicationMode!.Assign(value); }
    }
    private BicepValue<DistributedAvailabilityGroupReplicationMode>? _replicationMode;

    /// <summary>
    /// The secondary availability group name.
    /// </summary>
    public BicepValue<string> SecondaryAvailabilityGroupName 
    {
        get { Initialize(); return _secondaryAvailabilityGroupName!; }
        set { Initialize(); _secondaryAvailabilityGroupName!.Assign(value); }
    }
    private BicepValue<string>? _secondaryAvailabilityGroupName;

    /// <summary>
    /// The source endpoint.
    /// </summary>
    public BicepValue<string> SourceEndpoint 
    {
        get { Initialize(); return _sourceEndpoint!; }
        set { Initialize(); _sourceEndpoint!.Assign(value); }
    }
    private BicepValue<string>? _sourceEndpoint;

    /// <summary>
    /// The name of the target database.
    /// </summary>
    public BicepValue<string> TargetDatabase 
    {
        get { Initialize(); return _targetDatabase!; }
        set { Initialize(); _targetDatabase!.Assign(value); }
    }
    private BicepValue<string>? _targetDatabase;

    /// <summary>
    /// The distributed availability group id.
    /// </summary>
    public BicepValue<Guid> DistributedAvailabilityGroupId 
    {
        get { Initialize(); return _distributedAvailabilityGroupId!; }
    }
    private BicepValue<Guid>? _distributedAvailabilityGroupId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The last hardened lsn.
    /// </summary>
    public BicepValue<string> LastHardenedLsn 
    {
        get { Initialize(); return _lastHardenedLsn!; }
    }
    private BicepValue<string>? _lastHardenedLsn;

    /// <summary>
    /// The link state.
    /// </summary>
    public BicepValue<string> LinkState 
    {
        get { Initialize(); return _linkState!; }
    }
    private BicepValue<string>? _linkState;

    /// <summary>
    /// The source replica id.
    /// </summary>
    public BicepValue<Guid> SourceReplicaId 
    {
        get { Initialize(); return _sourceReplicaId!; }
    }
    private BicepValue<Guid>? _sourceReplicaId;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The target replica id.
    /// </summary>
    public BicepValue<Guid> TargetReplicaId 
    {
        get { Initialize(); return _targetReplicaId!; }
    }
    private BicepValue<Guid>? _targetReplicaId;

    /// <summary>
    /// Gets or sets a reference to the parent ManagedInstance.
    /// </summary>
    public ManagedInstance? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagedInstance>? _parent;

    /// <summary>
    /// Creates a new DistributedAvailabilityGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the DistributedAvailabilityGroup
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the DistributedAvailabilityGroup.</param>
    public DistributedAvailabilityGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Sql/managedInstances/distributedAvailabilityGroups", resourceVersion ?? "2021-11-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DistributedAvailabilityGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _primaryAvailabilityGroupName = DefineProperty<string>("PrimaryAvailabilityGroupName", ["properties", "primaryAvailabilityGroupName"]);
        _replicationMode = DefineProperty<DistributedAvailabilityGroupReplicationMode>("ReplicationMode", ["properties", "replicationMode"]);
        _secondaryAvailabilityGroupName = DefineProperty<string>("SecondaryAvailabilityGroupName", ["properties", "secondaryAvailabilityGroupName"]);
        _sourceEndpoint = DefineProperty<string>("SourceEndpoint", ["properties", "sourceEndpoint"]);
        _targetDatabase = DefineProperty<string>("TargetDatabase", ["properties", "targetDatabase"]);
        _distributedAvailabilityGroupId = DefineProperty<Guid>("DistributedAvailabilityGroupId", ["properties", "distributedAvailabilityGroupId"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _lastHardenedLsn = DefineProperty<string>("LastHardenedLsn", ["properties", "lastHardenedLsn"], isOutput: true);
        _linkState = DefineProperty<string>("LinkState", ["properties", "linkState"], isOutput: true);
        _sourceReplicaId = DefineProperty<Guid>("SourceReplicaId", ["properties", "sourceReplicaId"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _targetReplicaId = DefineProperty<Guid>("TargetReplicaId", ["properties", "targetReplicaId"], isOutput: true);
        _parent = DefineResource<ManagedInstance>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported DistributedAvailabilityGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";
    }

    /// <summary>
    /// Creates a reference to an existing DistributedAvailabilityGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the DistributedAvailabilityGroup
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the DistributedAvailabilityGroup.</param>
    /// <returns>The existing DistributedAvailabilityGroup resource.</returns>
    public static DistributedAvailabilityGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
