// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// SignalRService.
/// </summary>
public partial class SignalRService : ProvisionableResource
{
    /// <summary>
    /// The name of the resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets or sets the list of origins that should be allowed to make
    /// cross-origin calls (for example: http://example.com:12345). Use
    /// &quot;*&quot; to allow all. If omitted, allow all by default.
    /// </summary>
    public BicepList<string> CorsAllowedOrigins 
    {
        get { Initialize(); return _corsAllowedOrigins!; }
        set { Initialize(); _corsAllowedOrigins!.Assign(value); }
    }
    private BicepList<string>? _corsAllowedOrigins;

    /// <summary>
    /// DisableLocalAuth             Enable or disable aad auth
    /// When set as true, connection with AuthType=aad won&apos;t
    /// work.
    /// </summary>
    public BicepValue<bool> DisableAadAuth 
    {
        get { Initialize(); return _disableAadAuth!; }
        set { Initialize(); _disableAadAuth!.Assign(value); }
    }
    private BicepValue<bool>? _disableAadAuth;

    /// <summary>
    /// DisableLocalAuth             Enable or disable local auth with
    /// AccessKey             When set as true, connection with AccessKey=xxx
    /// won&apos;t work.
    /// </summary>
    public BicepValue<bool> DisableLocalAuth 
    {
        get { Initialize(); return _disableLocalAuth!; }
        set { Initialize(); _disableLocalAuth!.Assign(value); }
    }
    private BicepValue<bool>? _disableLocalAuth;

    /// <summary>
    /// List of the featureFlags.                           FeatureFlags that
    /// are not included in the parameters for the update operation will not
    /// be modified.              And the response will only include
    /// featureFlags that are explicitly set.              When a featureFlag
    /// is not explicitly set, its globally default value will be used
    /// But keep in mind, the default value doesn&apos;t mean
    /// &quot;false&quot;. It varies in terms of different FeatureFlags.
    /// </summary>
    public BicepList<SignalRFeature> Features 
    {
        get { Initialize(); return _features!; }
        set { Initialize(); _features!.Assign(value); }
    }
    private BicepList<SignalRFeature>? _features;

    /// <summary>
    /// A class represent managed identities used for request and response.
    /// Current supported identity types: None, SystemAssigned, UserAssigned.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Request client certificate during TLS handshake if enabled.
    /// </summary>
    public BicepValue<bool> IsClientCertEnabled 
    {
        get { Initialize(); return _isClientCertEnabled!; }
        set { Initialize(); _isClientCertEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isClientCertEnabled;

    /// <summary>
    /// The kind of the service, it can be SignalR or RawWebSockets.
    /// </summary>
    public BicepValue<SignalRServiceKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<SignalRServiceKind>? _kind;

    /// <summary>
    /// Live trace configuration of a Microsoft.SignalRService resource.
    /// </summary>
    public SignalRLiveTraceConfiguration LiveTraceConfiguration 
    {
        get { Initialize(); return _liveTraceConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _liveTraceConfiguration, value); }
    }
    private SignalRLiveTraceConfiguration? _liveTraceConfiguration;

    /// <summary>
    /// Network ACLs for the resource.
    /// </summary>
    public SignalRNetworkAcls NetworkACLs 
    {
        get { Initialize(); return _networkACLs!; }
        set { Initialize(); AssignOrReplace(ref _networkACLs, value); }
    }
    private SignalRNetworkAcls? _networkACLs;

    /// <summary>
    /// Enable or disable public network access. Default to
    /// &quot;Enabled&quot;.             When it&apos;s Enabled, network ACLs
    /// still apply.             When it&apos;s Disabled, public network
    /// access is always disabled no matter what you set in network ACLs.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// Gets or sets the list of category configurations.
    /// </summary>
    public BicepList<SignalRResourceLogCategory> ResourceLogCategories 
    {
        get { Initialize(); return _resourceLogCategories!; }
        set { Initialize(); _resourceLogCategories!.Assign(value); }
    }
    private BicepList<SignalRResourceLogCategory>? _resourceLogCategories;

    /// <summary>
    /// The billing information of the resource.
    /// </summary>
    public SignalRResourceSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private SignalRResourceSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Gets or sets the list of Upstream URL templates. Order matters, and the
    /// first matching template takes effects.
    /// </summary>
    public BicepList<SignalRUpstreamTemplate> UpstreamTemplates 
    {
        get { Initialize(); return _upstreamTemplates!; }
        set { Initialize(); _upstreamTemplates!.Assign(value); }
    }
    private BicepList<SignalRUpstreamTemplate>? _upstreamTemplates;

    /// <summary>
    /// The publicly accessible IP of the resource.
    /// </summary>
    public BicepValue<string> ExternalIP 
    {
        get { Initialize(); return _externalIP!; }
    }
    private BicepValue<string>? _externalIP;

    /// <summary>
    /// FQDN of the service instance.
    /// </summary>
    public BicepValue<string> HostName 
    {
        get { Initialize(); return _hostName!; }
    }
    private BicepValue<string>? _hostName;

    /// <summary>
    /// Deprecated.
    /// </summary>
    public BicepValue<string> HostNamePrefix 
    {
        get { Initialize(); return _hostNamePrefix!; }
    }
    private BicepValue<string>? _hostNamePrefix;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Private endpoint connections to the resource.
    /// </summary>
    public BicepList<SignalRPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<SignalRPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<SignalRProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<SignalRProvisioningState>? _provisioningState;

    /// <summary>
    /// The publicly accessible port of the resource which is designed for
    /// browser/client side usage.
    /// </summary>
    public BicepValue<int> PublicPort 
    {
        get { Initialize(); return _publicPort!; }
    }
    private BicepValue<int>? _publicPort;

    /// <summary>
    /// The publicly accessible port of the resource which is designed for
    /// customer server side usage.
    /// </summary>
    public BicepValue<int> ServerPort 
    {
        get { Initialize(); return _serverPort!; }
    }
    private BicepValue<int>? _serverPort;

    /// <summary>
    /// The list of shared private link resources.
    /// </summary>
    public BicepList<SignalRSharedPrivateLinkResourceData> SharedPrivateLinkResources 
    {
        get { Initialize(); return _sharedPrivateLinkResources!; }
    }
    private BicepList<SignalRSharedPrivateLinkResourceData>? _sharedPrivateLinkResources;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Version of the resource. Probably you need the same or higher version
    /// of client SDKs.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new SignalRService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SignalRService resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SignalRService.</param>
    public SignalRService(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.SignalRService/signalR", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SignalRService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _corsAllowedOrigins = DefineListProperty<string>("CorsAllowedOrigins", ["properties", "cors", "allowedOrigins"]);
        _disableAadAuth = DefineProperty<bool>("DisableAadAuth", ["properties", "disableAadAuth"]);
        _disableLocalAuth = DefineProperty<bool>("DisableLocalAuth", ["properties", "disableLocalAuth"]);
        _features = DefineListProperty<SignalRFeature>("Features", ["properties", "features"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _isClientCertEnabled = DefineProperty<bool>("IsClientCertEnabled", ["properties", "tls", "clientCertEnabled"]);
        _kind = DefineProperty<SignalRServiceKind>("Kind", ["kind"]);
        _liveTraceConfiguration = DefineModelProperty<SignalRLiveTraceConfiguration>("LiveTraceConfiguration", ["properties", "liveTraceConfiguration"]);
        _networkACLs = DefineModelProperty<SignalRNetworkAcls>("NetworkACLs", ["properties", "networkACLs"]);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _resourceLogCategories = DefineListProperty<SignalRResourceLogCategory>("ResourceLogCategories", ["properties", "resourceLogConfiguration", "categories"]);
        _sku = DefineModelProperty<SignalRResourceSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _upstreamTemplates = DefineListProperty<SignalRUpstreamTemplate>("UpstreamTemplates", ["properties", "upstream", "templates"]);
        _externalIP = DefineProperty<string>("ExternalIP", ["properties", "externalIP"], isOutput: true);
        _hostName = DefineProperty<string>("HostName", ["properties", "hostName"], isOutput: true);
        _hostNamePrefix = DefineProperty<string>("HostNamePrefix", ["properties", "hostNamePrefix"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<SignalRPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<SignalRProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _publicPort = DefineProperty<int>("PublicPort", ["properties", "publicPort"], isOutput: true);
        _serverPort = DefineProperty<int>("ServerPort", ["properties", "serverPort"], isOutput: true);
        _sharedPrivateLinkResources = DefineListProperty<SignalRSharedPrivateLinkResourceData>("SharedPrivateLinkResources", ["properties", "sharedPrivateLinkResources"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
    }

    /// <summary>
    /// Supported SignalRService resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-02-01.
        /// </summary>
        public static readonly string V2023_02_01 = "2023-02-01";

        /// <summary>
        /// 2022-02-01.
        /// </summary>
        public static readonly string V2022_02_01 = "2022-02-01";

        /// <summary>
        /// 2021-10-01.
        /// </summary>
        public static readonly string V2021_10_01 = "2021-10-01";

        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";

        /// <summary>
        /// 2018-10-01.
        /// </summary>
        public static readonly string V2018_10_01 = "2018-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing SignalRService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SignalRService resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SignalRService.</param>
    /// <returns>The existing SignalRService resource.</returns>
    public static SignalRService FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this SignalRService resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);

    /// <summary>
    /// Get access keys for this SignalRService resource.
    /// </summary>
    /// <returns>The keys for this SignalRService resource.</returns>
    public SignalRKeys GetKeys()
    {
        SignalRKeys key = new();
        ((IBicepValue)key).Expression = new FunctionCallExpression(new MemberExpression(new IdentifierExpression(BicepIdentifier), "listKeys"));
        return key;
    }

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this SignalRService.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(SignalRBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{SignalRBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// SignalRService.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(SignalRBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{SignalRBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
