// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Built-in SignalR roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct SignalRBuiltInRole(string value) : IEquatable<SignalRBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Read SignalR Service Access Keys
    /// </summary>
    public static SignalRBuiltInRole SignalRAccessKeyReader { get; } = new(SignalRAccessKeyReaderValue);
    internal const string SignalRAccessKeyReaderValue = "04165923-9d83-45d5-8227-78b77b0a687e";

    /// <summary>
    /// Lets your app server access SignalR Service with AAD auth options.
    /// </summary>
    public static SignalRBuiltInRole SignalRAppServer { get; } = new(SignalRAppServerValue);
    internal const string SignalRAppServerValue = "420fcaa2-552c-430f-98ca-3264be4806c7";

    /// <summary>
    /// Full access to Azure SignalR Service REST APIs
    /// </summary>
    public static SignalRBuiltInRole SignalRRestApiOwner { get; } = new(SignalRRestApiOwnerValue);
    internal const string SignalRRestApiOwnerValue = "fd53cd77-2268-407a-8f46-7e7863d0f521";

    /// <summary>
    /// Read-only access to Azure SignalR Service REST APIs
    /// </summary>
    public static SignalRBuiltInRole SignalRRestApiReader { get; } = new(SignalRRestApiReaderValue);
    internal const string SignalRRestApiReaderValue = "ddde6b66-c0df-4114-a159-3618637b3035";

    /// <summary>
    /// Full access to Azure SignalR Service REST APIs
    /// </summary>
    public static SignalRBuiltInRole SignalRServiceOwner { get; } = new(SignalRServiceOwnerValue);
    internal const string SignalRServiceOwnerValue = "7e4f1700-ea5a-4f59-8f37-079cfe29dce3";

    /// <summary>
    /// Create, Read, Update, and Delete SignalR service resources
    /// </summary>
    public static SignalRBuiltInRole SignalRContributor { get; } = new(SignalRContributorValue);
    internal const string SignalRContributorValue = "8cf5e20a-e4b2-4e9d-b3a1-5ceb692c2761";

    /// <summary>
    /// Try to get the name of a built-in SignalR role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in SignalR role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(SignalRBuiltInRole value) =>
        value._value switch
        {
            SignalRAccessKeyReaderValue => nameof(SignalRAccessKeyReader),
            SignalRAppServerValue => nameof(SignalRAppServer),
            SignalRRestApiOwnerValue => nameof(SignalRRestApiOwner),
            SignalRRestApiReaderValue => nameof(SignalRRestApiReader),
            SignalRServiceOwnerValue => nameof(SignalRServiceOwner),
            SignalRContributorValue => nameof(SignalRContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two SignalRBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first SignalRBuiltInRole to compare.</param>
    /// <param name="right">The second SignalRBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(SignalRBuiltInRole left, SignalRBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two SignalRBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first SignalRBuiltInRole to compare.</param>
    /// <param name="right">The second SignalRBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(SignalRBuiltInRole left, SignalRBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a SignalRBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator SignalRBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is SignalRBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(SignalRBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
