// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Upstream template item settings. It defines the Upstream URL of the
/// incoming requests.             The template defines the pattern of the
/// event, the hub or the category of the incoming request that matches
/// current URL template.
/// </summary>
public partial class SignalRUpstreamTemplate : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the matching pattern for hub names. If not set, it matches
    /// any hub.             There are 3 kind of patterns supported:
    /// 1. &quot;*&quot;, it to matches any hub name.
    /// 2. Combine multiple hubs with &quot;,&quot;, for
    /// example &quot;hub1,hub2&quot;, it matches &quot;hub1&quot; and
    /// &quot;hub2&quot;.                 3. The single hub name, for example,
    /// &quot;hub1&quot;, it matches &quot;hub1&quot;.
    /// </summary>
    public BicepValue<string> HubPattern 
    {
        get { Initialize(); return _hubPattern!; }
        set { Initialize(); _hubPattern!.Assign(value); }
    }
    private BicepValue<string>? _hubPattern;

    /// <summary>
    /// Gets or sets the matching pattern for event names. If not set, it
    /// matches any event.             There are 3 kind of patterns supported:
    /// 1. &quot;*&quot;, it to matches any event name.
    /// 2. Combine multiple events with &quot;,&quot;, for
    /// example &quot;connect,disconnect&quot;, it matches event
    /// &quot;connect&quot; and &quot;disconnect&quot;.                 3. The
    /// single event name, for example, &quot;connect&quot;, it matches
    /// &quot;connect&quot;.
    /// </summary>
    public BicepValue<string> EventPattern 
    {
        get { Initialize(); return _eventPattern!; }
        set { Initialize(); _eventPattern!.Assign(value); }
    }
    private BicepValue<string>? _eventPattern;

    /// <summary>
    /// Gets or sets the matching pattern for category names. If not set, it
    /// matches any category.             There are 3 kind of patterns
    /// supported:                 1. &quot;*&quot;, it to matches any
    /// category name.                 2. Combine multiple categories with
    /// &quot;,&quot;, for example &quot;connections,messages&quot;, it
    /// matches category &quot;connections&quot; and &quot;messages&quot;.
    /// 3. The single category name, for example,
    /// &quot;connections&quot;, it matches the category
    /// &quot;connections&quot;.
    /// </summary>
    public BicepValue<string> CategoryPattern 
    {
        get { Initialize(); return _categoryPattern!; }
        set { Initialize(); _categoryPattern!.Assign(value); }
    }
    private BicepValue<string>? _categoryPattern;

    /// <summary>
    /// Gets or sets the Upstream URL template. You can use 3 predefined
    /// parameters {hub}, {category} {event} inside the template, the value of
    /// the Upstream URL is dynamically calculated when the client request
    /// comes in.             For example, if the urlTemplate is
    /// `http://example.com/{hub}/api/{event}`, with a client request from hub
    /// `chat` connects, it will first POST to this URL:
    /// `http://example.com/chat/api/connect`.
    /// </summary>
    public BicepValue<string> UrlTemplate 
    {
        get { Initialize(); return _urlTemplate!; }
        set { Initialize(); _urlTemplate!.Assign(value); }
    }
    private BicepValue<string>? _urlTemplate;

    /// <summary>
    /// Upstream auth settings. If not set, no auth is used for upstream
    /// messages.
    /// </summary>
    public SignalRUpstreamAuthSettings Auth 
    {
        get { Initialize(); return _auth!; }
        set { Initialize(); AssignOrReplace(ref _auth, value); }
    }
    private SignalRUpstreamAuthSettings? _auth;

    /// <summary>
    /// Creates a new SignalRUpstreamTemplate.
    /// </summary>
    public SignalRUpstreamTemplate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SignalRUpstreamTemplate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _hubPattern = DefineProperty<string>("HubPattern", ["hubPattern"]);
        _eventPattern = DefineProperty<string>("EventPattern", ["eventPattern"]);
        _categoryPattern = DefineProperty<string>("CategoryPattern", ["categoryPattern"]);
        _urlTemplate = DefineProperty<string>("UrlTemplate", ["urlTemplate"]);
        _auth = DefineModelProperty<SignalRUpstreamAuthSettings>("Auth", ["auth"]);
    }
}
