// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// A class representing the SignalRSharedPrivateLinkResource data model.
/// Describes a Shared Private Link Resource
/// </summary>
public partial class SignalRSharedPrivateLinkResourceData : ProvisionableConstruct
{
    /// <summary>
    /// The group id from the provider of resource the shared private link
    /// resource is for.
    /// </summary>
    public BicepValue<string> GroupId 
    {
        get { Initialize(); return _groupId!; }
        set { Initialize(); _groupId!.Assign(value); }
    }
    private BicepValue<string>? _groupId;

    /// <summary>
    /// The resource id of the resource the shared private link resource is for.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateLinkResourceId 
    {
        get { Initialize(); return _privateLinkResourceId!; }
        set { Initialize(); _privateLinkResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _privateLinkResourceId;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<SignalRProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<SignalRProvisioningState>? _provisioningState;

    /// <summary>
    /// The request message for requesting approval of the shared private link
    /// resource.
    /// </summary>
    public BicepValue<string> RequestMessage 
    {
        get { Initialize(); return _requestMessage!; }
        set { Initialize(); _requestMessage!.Assign(value); }
    }
    private BicepValue<string>? _requestMessage;

    /// <summary>
    /// Status of the shared private link resource.
    /// </summary>
    public BicepValue<SignalRSharedPrivateLinkResourceStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<SignalRSharedPrivateLinkResourceStatus>? _status;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SignalRSharedPrivateLinkResourceData.
    /// </summary>
    public SignalRSharedPrivateLinkResourceData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SignalRSharedPrivateLinkResourceData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _groupId = DefineProperty<string>("GroupId", ["properties", "groupId"]);
        _privateLinkResourceId = DefineProperty<ResourceIdentifier>("PrivateLinkResourceId", ["properties", "privateLinkResourceId"]);
        _provisioningState = DefineProperty<SignalRProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _requestMessage = DefineProperty<string>("RequestMessage", ["properties", "requestMessage"]);
        _status = DefineProperty<SignalRSharedPrivateLinkResourceStatus>("Status", ["properties", "status"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
