// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Resource log category configuration of a Microsoft.SignalRService resource.
/// </summary>
public partial class SignalRResourceLogCategory : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the resource log category&apos;s name.
    /// Available values: ConnectivityLogs, MessagingLogs.
    /// Case insensitive.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Indicates whether or the resource log category is enabled.
    /// Available values: true, false.             Case
    /// insensitive.
    /// </summary>
    public BicepValue<string> Enabled 
    {
        get { Initialize(); return _enabled!; }
        set { Initialize(); _enabled!.Assign(value); }
    }
    private BicepValue<string>? _enabled;

    /// <summary>
    /// Creates a new SignalRResourceLogCategory.
    /// </summary>
    public SignalRResourceLogCategory()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SignalRResourceLogCategory.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _enabled = DefineProperty<string>("Enabled", ["enabled"]);
    }
}
