// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Network ACLs for the resource.
/// </summary>
public partial class SignalRNetworkAcls : ProvisionableConstruct
{
    /// <summary>
    /// Azure Networking ACL Action.
    /// </summary>
    public BicepValue<SignalRNetworkAclAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<SignalRNetworkAclAction>? _defaultAction;

    /// <summary>
    /// Network ACL.
    /// </summary>
    public SignalRNetworkAcl PublicNetwork 
    {
        get { Initialize(); return _publicNetwork!; }
        set { Initialize(); AssignOrReplace(ref _publicNetwork, value); }
    }
    private SignalRNetworkAcl? _publicNetwork;

    /// <summary>
    /// ACLs for requests from private endpoints.
    /// </summary>
    public BicepList<SignalRPrivateEndpointAcl> PrivateEndpoints 
    {
        get { Initialize(); return _privateEndpoints!; }
        set { Initialize(); _privateEndpoints!.Assign(value); }
    }
    private BicepList<SignalRPrivateEndpointAcl>? _privateEndpoints;

    /// <summary>
    /// Creates a new SignalRNetworkAcls.
    /// </summary>
    public SignalRNetworkAcls()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SignalRNetworkAcls.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _defaultAction = DefineProperty<SignalRNetworkAclAction>("DefaultAction", ["defaultAction"]);
        _publicNetwork = DefineModelProperty<SignalRNetworkAcl>("PublicNetwork", ["publicNetwork"]);
        _privateEndpoints = DefineListProperty<SignalRPrivateEndpointAcl>("PrivateEndpoints", ["privateEndpoints"]);
    }
}
