// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Live trace configuration of a Microsoft.SignalRService resource.
/// </summary>
public partial class SignalRLiveTraceConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether or not enable live trace.             When it&apos;s
    /// set to true, live trace client can connect to the service.
    /// Otherwise, live trace client can&apos;t connect to the
    /// service, so that you are unable to receive any log, no matter what you
    /// configure in &quot;categories&quot;.             Available values:
    /// true, false.             Case insensitive.
    /// </summary>
    public BicepValue<string> Enabled 
    {
        get { Initialize(); return _enabled!; }
        set { Initialize(); _enabled!.Assign(value); }
    }
    private BicepValue<string>? _enabled;

    /// <summary>
    /// Gets or sets the list of category configurations.
    /// </summary>
    public BicepList<SignalRLiveTraceCategory> Categories 
    {
        get { Initialize(); return _categories!; }
        set { Initialize(); _categories!.Assign(value); }
    }
    private BicepList<SignalRLiveTraceCategory>? _categories;

    /// <summary>
    /// Creates a new SignalRLiveTraceConfiguration.
    /// </summary>
    public SignalRLiveTraceConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SignalRLiveTraceConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _enabled = DefineProperty<string>("Enabled", ["enabled"]);
        _categories = DefineListProperty<SignalRLiveTraceCategory>("Categories", ["categories"]);
    }
}
