// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.SignalR;

/// <summary>
/// FeatureFlags is the supported features of Azure SignalR service.
/// - ServiceMode: Flag for backend server for SignalR service.
/// Values allowed: &quot;Default&quot;: have your own backend server;
/// &quot;Serverless&quot;: your application doesn&apos;t have a backend
/// server; &quot;Classic&quot;: for backward compatibility. Support both
/// Default and Serverless mode but not recommended;
/// &quot;PredefinedOnly&quot;: for future use.             -
/// EnableConnectivityLogs: &quot;true&quot;/&quot;false&quot;, to
/// enable/disable the connectivity log category respectively.             -
/// EnableMessagingLogs: &quot;true&quot;/&quot;false&quot;, to enable/disable
/// the connectivity log category respectively.             - EnableLiveTrace:
/// Live Trace allows you to know what&apos;s happening inside Azure SignalR
/// service, it will give you live traces in real time, it will be helpful
/// when you developing your own Azure SignalR based web application or
/// self-troubleshooting some issues. Please note that live traces are counted
/// as outbound messages that will be charged. Values allowed:
/// &quot;true&quot;/&quot;false&quot;, to enable/disable live trace feature.
/// </summary>
public enum SignalRFeatureFlag
{
    /// <summary>
    /// ServiceMode.
    /// </summary>
    ServiceMode,

    /// <summary>
    /// EnableConnectivityLogs.
    /// </summary>
    EnableConnectivityLogs,

    /// <summary>
    /// EnableMessagingLogs.
    /// </summary>
    EnableMessagingLogs,

    /// <summary>
    /// EnableLiveTrace.
    /// </summary>
    EnableLiveTrace,
}
