// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.SignalR;

/// <summary>
/// Feature of a resource, which controls the runtime behavior.
/// </summary>
public partial class SignalRFeature : ProvisionableConstruct
{
    /// <summary>
    /// FeatureFlags is the supported features of Azure SignalR service.
    /// - ServiceMode: Flag for backend server for SignalR
    /// service. Values allowed: &quot;Default&quot;: have your own backend
    /// server; &quot;Serverless&quot;: your application doesn&apos;t have a
    /// backend server; &quot;Classic&quot;: for backward compatibility.
    /// Support both Default and Serverless mode but not recommended;
    /// &quot;PredefinedOnly&quot;: for future use.             -
    /// EnableConnectivityLogs: &quot;true&quot;/&quot;false&quot;, to
    /// enable/disable the connectivity log category respectively.
    /// - EnableMessagingLogs: &quot;true&quot;/&quot;false&quot;,
    /// to enable/disable the connectivity log category respectively.
    /// - EnableLiveTrace: Live Trace allows you to know
    /// what&apos;s happening inside Azure SignalR service, it will give you
    /// live traces in real time, it will be helpful when you developing your
    /// own Azure SignalR based web application or self-troubleshooting some
    /// issues. Please note that live traces are counted as outbound messages
    /// that will be charged. Values allowed:
    /// &quot;true&quot;/&quot;false&quot;, to enable/disable live trace
    /// feature.
    /// </summary>
    public BicepValue<SignalRFeatureFlag> Flag 
    {
        get { Initialize(); return _flag!; }
        set { Initialize(); _flag!.Assign(value); }
    }
    private BicepValue<SignalRFeatureFlag>? _flag;

    /// <summary>
    /// Value of the feature flag. See Azure SignalR service document
    /// https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Optional properties related to this feature.
    /// </summary>
    public BicepDictionary<string> Properties 
    {
        get { Initialize(); return _properties!; }
        set { Initialize(); _properties!.Assign(value); }
    }
    private BicepDictionary<string>? _properties;

    /// <summary>
    /// Creates a new SignalRFeature.
    /// </summary>
    public SignalRFeature()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SignalRFeature.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _flag = DefineProperty<SignalRFeatureFlag>("Flag", ["flag"]);
        _value = DefineProperty<string>("Value", ["value"]);
        _properties = DefineDictionaryProperty<string>("Properties", ["properties"]);
    }
}
