// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// ServiceBusNetworkRuleSet.
/// </summary>
public partial class ServiceBusNetworkRuleSet : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Default Action for Network Rule Set.
    /// </summary>
    public BicepValue<ServiceBusNetworkRuleSetDefaultAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<ServiceBusNetworkRuleSetDefaultAction>? _defaultAction;

    /// <summary>
    /// List of IpRules.
    /// </summary>
    public BicepList<ServiceBusNetworkRuleSetIPRules> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<ServiceBusNetworkRuleSetIPRules>? _iPRules;

    /// <summary>
    /// Value that indicates whether Trusted Service Access is Enabled or not.
    /// </summary>
    public BicepValue<bool> IsTrustedServiceAccessEnabled 
    {
        get { Initialize(); return _isTrustedServiceAccessEnabled!; }
        set { Initialize(); _isTrustedServiceAccessEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isTrustedServiceAccessEnabled;

    /// <summary>
    /// This determines if traffic is allowed over public network. By default
    /// it is enabled.
    /// </summary>
    public BicepValue<ServiceBusPublicNetworkAccessFlag> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<ServiceBusPublicNetworkAccessFlag>? _publicNetworkAccess;

    /// <summary>
    /// List VirtualNetwork Rules.
    /// </summary>
    public BicepList<ServiceBusNetworkRuleSetVirtualNetworkRules> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<ServiceBusNetworkRuleSetVirtualNetworkRules>? _virtualNetworkRules;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ServiceBusNamespace.
    /// </summary>
    public ServiceBusNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ServiceBusNamespace>? _parent;

    /// <summary>
    /// Creates a new ServiceBusNetworkRuleSet.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ServiceBusNetworkRuleSet resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ServiceBusNetworkRuleSet.</param>
    public ServiceBusNetworkRuleSet(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ServiceBus/namespaces/networkRuleSets", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _defaultAction = DefineProperty<ServiceBusNetworkRuleSetDefaultAction>("DefaultAction", ["properties", "defaultAction"]);
        _iPRules = DefineListProperty<ServiceBusNetworkRuleSetIPRules>("IPRules", ["properties", "ipRules"]);
        _isTrustedServiceAccessEnabled = DefineProperty<bool>("IsTrustedServiceAccessEnabled", ["properties", "trustedServiceAccessEnabled"]);
        _publicNetworkAccess = DefineProperty<ServiceBusPublicNetworkAccessFlag>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _virtualNetworkRules = DefineListProperty<ServiceBusNetworkRuleSetVirtualNetworkRules>("VirtualNetworkRules", ["properties", "virtualNetworkRules"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ServiceBusNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ServiceBusNetworkRuleSet resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing ServiceBusNetworkRuleSet.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ServiceBusNetworkRuleSet resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ServiceBusNetworkRuleSet.</param>
    /// <returns>The existing ServiceBusNetworkRuleSet resource.</returns>
    public static ServiceBusNetworkRuleSet FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
