// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// ServiceBusDisasterRecovery.
/// </summary>
public partial class ServiceBusDisasterRecovery : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Primary/Secondary eventhub namespace name, which is part of GEO DR
    /// pairing.
    /// </summary>
    public BicepValue<string> AlternateName 
    {
        get { Initialize(); return _alternateName!; }
        set { Initialize(); _alternateName!.Assign(value); }
    }
    private BicepValue<string>? _alternateName;

    /// <summary>
    /// ARM Id of the Primary/Secondary eventhub namespace name, which is part
    /// of GEO DR pairing.
    /// </summary>
    public BicepValue<string> PartnerNamespace 
    {
        get { Initialize(); return _partnerNamespace!; }
        set { Initialize(); _partnerNamespace!.Assign(value); }
    }
    private BicepValue<string>? _partnerNamespace;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Number of entities pending to be replicated.
    /// </summary>
    public BicepValue<long> PendingReplicationOperationsCount 
    {
        get { Initialize(); return _pendingReplicationOperationsCount!; }
    }
    private BicepValue<long>? _pendingReplicationOperationsCount;

    /// <summary>
    /// Provisioning state of the Alias(Disaster Recovery configuration) -
    /// possible values &apos;Accepted&apos; or &apos;Succeeded&apos; or
    /// &apos;Failed&apos;.
    /// </summary>
    public BicepValue<ServiceBusDisasterRecoveryProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ServiceBusDisasterRecoveryProvisioningState>? _provisioningState;

    /// <summary>
    /// role of namespace in GEO DR - possible values &apos;Primary&apos; or
    /// &apos;PrimaryNotReplicating&apos; or &apos;Secondary&apos;.
    /// </summary>
    public BicepValue<ServiceBusDisasterRecoveryRole> Role 
    {
        get { Initialize(); return _role!; }
    }
    private BicepValue<ServiceBusDisasterRecoveryRole>? _role;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ServiceBusNamespace.
    /// </summary>
    public ServiceBusNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ServiceBusNamespace>? _parent;

    /// <summary>
    /// Creates a new ServiceBusDisasterRecovery.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ServiceBusDisasterRecovery
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ServiceBusDisasterRecovery.</param>
    public ServiceBusDisasterRecovery(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ServiceBus/namespaces/disasterRecoveryConfigs", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusDisasterRecovery.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _alternateName = DefineProperty<string>("AlternateName", ["properties", "alternateName"]);
        _partnerNamespace = DefineProperty<string>("PartnerNamespace", ["properties", "partnerNamespace"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _pendingReplicationOperationsCount = DefineProperty<long>("PendingReplicationOperationsCount", ["properties", "pendingReplicationOperationsCount"], isOutput: true);
        _provisioningState = DefineProperty<ServiceBusDisasterRecoveryProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _role = DefineProperty<ServiceBusDisasterRecoveryRole>("Role", ["properties", "role"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ServiceBusNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ServiceBusDisasterRecovery resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing ServiceBusDisasterRecovery.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ServiceBusDisasterRecovery
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ServiceBusDisasterRecovery.</param>
    /// <returns>The existing ServiceBusDisasterRecovery resource.</returns>
    public static ServiceBusDisasterRecovery FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ServiceBusDisasterRecovery
    /// resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 6, maxLength: 50, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
