// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Built-in ServiceBus roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct ServiceBusBuiltInRole(string value) : IEquatable<ServiceBusBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Allows for full access to Azure Service Bus resources.
    /// </summary>
    public static ServiceBusBuiltInRole AzureServiceBusDataOwner { get; } = new(AzureServiceBusDataOwnerValue);
    internal const string AzureServiceBusDataOwnerValue = "090c5cfd-751d-490a-894a-3ce6f1109419";

    /// <summary>
    /// Allows for receive access to Azure Service Bus resources.
    /// </summary>
    public static ServiceBusBuiltInRole AzureServiceBusDataReceiver { get; } = new(AzureServiceBusDataReceiverValue);
    internal const string AzureServiceBusDataReceiverValue = "4f6d3b9b-027b-4f4c-9142-0e5a2a2247e0";

    /// <summary>
    /// Allows for send access to Azure Service Bus resources.
    /// </summary>
    public static ServiceBusBuiltInRole AzureServiceBusDataSender { get; } = new(AzureServiceBusDataSenderValue);
    internal const string AzureServiceBusDataSenderValue = "69a216fc-b8fb-44d8-bc22-1f3c2cd27a39";

    /// <summary>
    /// Try to get the name of a built-in ServiceBus role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in ServiceBus role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(ServiceBusBuiltInRole value) =>
        value._value switch
        {
            AzureServiceBusDataOwnerValue => nameof(AzureServiceBusDataOwner),
            AzureServiceBusDataReceiverValue => nameof(AzureServiceBusDataReceiver),
            AzureServiceBusDataSenderValue => nameof(AzureServiceBusDataSender),
            _ => value._value
        };

    /// <summary>
    /// Determines if two ServiceBusBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first ServiceBusBuiltInRole to compare.</param>
    /// <param name="right">The second ServiceBusBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(ServiceBusBuiltInRole left, ServiceBusBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two ServiceBusBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first ServiceBusBuiltInRole to compare.</param>
    /// <param name="right">The second ServiceBusBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(ServiceBusBuiltInRole left, ServiceBusBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a ServiceBusBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator ServiceBusBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is ServiceBusBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(ServiceBusBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
