// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// SKU of the namespace.
/// </summary>
public partial class ServiceBusSku : ProvisionableConstruct
{
    /// <summary>
    /// Name of this SKU.
    /// </summary>
    public BicepValue<ServiceBusSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<ServiceBusSkuName>? _name;

    /// <summary>
    /// The billing tier of this particular SKU.
    /// </summary>
    public BicepValue<ServiceBusSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<ServiceBusSkuTier>? _tier;

    /// <summary>
    /// Messaging units for your service bus premium namespace. Valid
    /// capacities are {1, 2, 4, 8, 16} multiples of your
    /// properties.premiumMessagingPartitions setting. For example, If
    /// properties.premiumMessagingPartitions is 1 then possible capacity
    /// values are 1, 2, 4, 8, and 16. If
    /// properties.premiumMessagingPartitions is 4 then possible capacity
    /// values are 4, 8, 16, 32 and 64.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new ServiceBusSku.
    /// </summary>
    public ServiceBusSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<ServiceBusSkuName>("Name", ["name"]);
        _tier = DefineProperty<ServiceBusSkuTier>("Tier", ["tier"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
