// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// ConnectionState information.
/// </summary>
public partial class ServiceBusPrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// Status of the connection.
    /// </summary>
    public BicepValue<ServiceBusPrivateLinkConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ServiceBusPrivateLinkConnectionStatus>? _status;

    /// <summary>
    /// Description of the connection state.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Creates a new ServiceBusPrivateLinkServiceConnectionState.
    /// </summary>
    public ServiceBusPrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceBusPrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<ServiceBusPrivateLinkConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
    }
}
