// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Description of VirtualNetworkRules - NetworkRules resource.
/// </summary>
public partial class ServiceBusNetworkRuleSetVirtualNetworkRules : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> SubnetId 
    {
        get { Initialize(); return _subnetId!; }
        set { Initialize(); _subnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _subnetId;

    /// <summary>
    /// Value that indicates whether to ignore missing VNet Service Endpoint.
    /// </summary>
    public BicepValue<bool> IgnoreMissingVnetServiceEndpoint 
    {
        get { Initialize(); return _ignoreMissingVnetServiceEndpoint!; }
        set { Initialize(); _ignoreMissingVnetServiceEndpoint!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreMissingVnetServiceEndpoint;

    /// <summary>
    /// Creates a new ServiceBusNetworkRuleSetVirtualNetworkRules.
    /// </summary>
    public ServiceBusNetworkRuleSetVirtualNetworkRules()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceBusNetworkRuleSetVirtualNetworkRules.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _subnetId = DefineProperty<ResourceIdentifier>("SubnetId", ["subnet", "id"]);
        _ignoreMissingVnetServiceEndpoint = DefineProperty<bool>("IgnoreMissingVnetServiceEndpoint", ["ignoreMissingVnetServiceEndpoint"]);
    }
}
