// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Properties to configure keyVault Properties.
/// </summary>
public partial class ServiceBusKeyVaultProperties : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Key from KeyVault.
    /// </summary>
    public BicepValue<string> KeyName 
    {
        get { Initialize(); return _keyName!; }
        set { Initialize(); _keyName!.Assign(value); }
    }
    private BicepValue<string>? _keyName;

    /// <summary>
    /// Uri of KeyVault.
    /// </summary>
    public BicepValue<Uri> KeyVaultUri 
    {
        get { Initialize(); return _keyVaultUri!; }
        set { Initialize(); _keyVaultUri!.Assign(value); }
    }
    private BicepValue<Uri>? _keyVaultUri;

    /// <summary>
    /// Version of KeyVault.
    /// </summary>
    public BicepValue<string> KeyVersion 
    {
        get { Initialize(); return _keyVersion!; }
        set { Initialize(); _keyVersion!.Assign(value); }
    }
    private BicepValue<string>? _keyVersion;

    /// <summary>
    /// ARM ID of user Identity selected for encryption.
    /// </summary>
    public BicepValue<string> UserAssignedIdentity 
    {
        get { Initialize(); return _userAssignedIdentity!; }
        set { Initialize(); _userAssignedIdentity!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentity;

    /// <summary>
    /// Creates a new ServiceBusKeyVaultProperties.
    /// </summary>
    public ServiceBusKeyVaultProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusKeyVaultProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyName = DefineProperty<string>("KeyName", ["keyName"]);
        _keyVaultUri = DefineProperty<Uri>("KeyVaultUri", ["keyVaultUri"]);
        _keyVersion = DefineProperty<string>("KeyVersion", ["keyVersion"]);
        _userAssignedIdentity = DefineProperty<string>("UserAssignedIdentity", ["identity", "userAssignedIdentity"]);
    }
}
