// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Represents the filter actions which are allowed for the transformation of a
/// message that have been matched by a filter expression.
/// </summary>
public partial class ServiceBusFilterAction : ProvisionableConstruct
{
    /// <summary>
    /// SQL expression. e.g. MyProperty=&apos;ABC&apos;.
    /// </summary>
    public BicepValue<string> SqlExpression 
    {
        get { Initialize(); return _sqlExpression!; }
        set { Initialize(); _sqlExpression!.Assign(value); }
    }
    private BicepValue<string>? _sqlExpression;

    /// <summary>
    /// This property is reserved for future use. An integer value showing the
    /// compatibility level, currently hard-coded to 20.
    /// </summary>
    public BicepValue<int> CompatibilityLevel 
    {
        get { Initialize(); return _compatibilityLevel!; }
        set { Initialize(); _compatibilityLevel!.Assign(value); }
    }
    private BicepValue<int>? _compatibilityLevel;

    /// <summary>
    /// Value that indicates whether the rule action requires preprocessing.
    /// </summary>
    public BicepValue<bool> RequiresPreprocessing 
    {
        get { Initialize(); return _requiresPreprocessing!; }
        set { Initialize(); _requiresPreprocessing!.Assign(value); }
    }
    private BicepValue<bool>? _requiresPreprocessing;

    /// <summary>
    /// Creates a new ServiceBusFilterAction.
    /// </summary>
    public ServiceBusFilterAction()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusFilterAction.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sqlExpression = DefineProperty<string>("SqlExpression", ["sqlExpression"]);
        _compatibilityLevel = DefineProperty<int>("CompatibilityLevel", ["compatibilityLevel"]);
        _requiresPreprocessing = DefineProperty<bool>("RequiresPreprocessing", ["requiresPreprocessing"]);
    }
}
