// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Properties to configure Encryption.
/// </summary>
public partial class ServiceBusEncryption : ProvisionableConstruct
{
    /// <summary>
    /// Properties of KeyVault.
    /// </summary>
    public BicepList<ServiceBusKeyVaultProperties> KeyVaultProperties 
    {
        get { Initialize(); return _keyVaultProperties!; }
        set { Initialize(); _keyVaultProperties!.Assign(value); }
    }
    private BicepList<ServiceBusKeyVaultProperties>? _keyVaultProperties;

    /// <summary>
    /// Enumerates the possible value of keySource for Encryption.
    /// </summary>
    public BicepValue<ServiceBusEncryptionKeySource> KeySource 
    {
        get { Initialize(); return _keySource!; }
        set { Initialize(); _keySource!.Assign(value); }
    }
    private BicepValue<ServiceBusEncryptionKeySource>? _keySource;

    /// <summary>
    /// Enable Infrastructure Encryption (Double Encryption).
    /// </summary>
    public BicepValue<bool> RequireInfrastructureEncryption 
    {
        get { Initialize(); return _requireInfrastructureEncryption!; }
        set { Initialize(); _requireInfrastructureEncryption!.Assign(value); }
    }
    private BicepValue<bool>? _requireInfrastructureEncryption;

    /// <summary>
    /// Creates a new ServiceBusEncryption.
    /// </summary>
    public ServiceBusEncryption()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusEncryption.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyVaultProperties = DefineListProperty<ServiceBusKeyVaultProperties>("KeyVaultProperties", ["keyVaultProperties"]);
        _keySource = DefineProperty<ServiceBusEncryptionKeySource>("KeySource", ["keySource"]);
        _requireInfrastructureEncryption = DefineProperty<bool>("RequireInfrastructureEncryption", ["requireInfrastructureEncryption"]);
    }
}
