// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Represents the correlation filter expression.
/// </summary>
public partial class ServiceBusCorrelationFilter : ProvisionableConstruct
{
    /// <summary>
    /// dictionary object for custom filters.
    /// </summary>
    public BicepDictionary<object> ApplicationProperties 
    {
        get { Initialize(); return _applicationProperties!; }
        set { Initialize(); _applicationProperties!.Assign(value); }
    }
    private BicepDictionary<object>? _applicationProperties;

    /// <summary>
    /// Identifier of the correlation.
    /// </summary>
    public BicepValue<string> CorrelationId 
    {
        get { Initialize(); return _correlationId!; }
        set { Initialize(); _correlationId!.Assign(value); }
    }
    private BicepValue<string>? _correlationId;

    /// <summary>
    /// Identifier of the message.
    /// </summary>
    public BicepValue<string> MessageId 
    {
        get { Initialize(); return _messageId!; }
        set { Initialize(); _messageId!.Assign(value); }
    }
    private BicepValue<string>? _messageId;

    /// <summary>
    /// Address to send to.
    /// </summary>
    public BicepValue<string> SendTo 
    {
        get { Initialize(); return _sendTo!; }
        set { Initialize(); _sendTo!.Assign(value); }
    }
    private BicepValue<string>? _sendTo;

    /// <summary>
    /// Address of the queue to reply to.
    /// </summary>
    public BicepValue<string> ReplyTo 
    {
        get { Initialize(); return _replyTo!; }
        set { Initialize(); _replyTo!.Assign(value); }
    }
    private BicepValue<string>? _replyTo;

    /// <summary>
    /// Application specific label.
    /// </summary>
    public BicepValue<string> Subject 
    {
        get { Initialize(); return _subject!; }
        set { Initialize(); _subject!.Assign(value); }
    }
    private BicepValue<string>? _subject;

    /// <summary>
    /// Session identifier.
    /// </summary>
    public BicepValue<string> SessionId 
    {
        get { Initialize(); return _sessionId!; }
        set { Initialize(); _sessionId!.Assign(value); }
    }
    private BicepValue<string>? _sessionId;

    /// <summary>
    /// Session identifier to reply to.
    /// </summary>
    public BicepValue<string> ReplyToSessionId 
    {
        get { Initialize(); return _replyToSessionId!; }
        set { Initialize(); _replyToSessionId!.Assign(value); }
    }
    private BicepValue<string>? _replyToSessionId;

    /// <summary>
    /// Content type of the message.
    /// </summary>
    public BicepValue<string> ContentType 
    {
        get { Initialize(); return _contentType!; }
        set { Initialize(); _contentType!.Assign(value); }
    }
    private BicepValue<string>? _contentType;

    /// <summary>
    /// Value that indicates whether the rule action requires preprocessing.
    /// </summary>
    public BicepValue<bool> RequiresPreprocessing 
    {
        get { Initialize(); return _requiresPreprocessing!; }
        set { Initialize(); _requiresPreprocessing!.Assign(value); }
    }
    private BicepValue<bool>? _requiresPreprocessing;

    /// <summary>
    /// Creates a new ServiceBusCorrelationFilter.
    /// </summary>
    public ServiceBusCorrelationFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusCorrelationFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _applicationProperties = DefineDictionaryProperty<object>("ApplicationProperties", ["properties"]);
        _correlationId = DefineProperty<string>("CorrelationId", ["correlationId"]);
        _messageId = DefineProperty<string>("MessageId", ["messageId"]);
        _sendTo = DefineProperty<string>("SendTo", ["to"]);
        _replyTo = DefineProperty<string>("ReplyTo", ["replyTo"]);
        _subject = DefineProperty<string>("Subject", ["label"]);
        _sessionId = DefineProperty<string>("SessionId", ["sessionId"]);
        _replyToSessionId = DefineProperty<string>("ReplyToSessionId", ["replyToSessionId"]);
        _contentType = DefineProperty<string>("ContentType", ["contentType"]);
        _requiresPreprocessing = DefineProperty<bool>("RequiresPreprocessing", ["requiresPreprocessing"]);
    }
}
