// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Properties specific to client affine subscriptions.
/// </summary>
public partial class ServiceBusClientAffineProperties : ProvisionableConstruct
{
    /// <summary>
    /// Indicates the Client ID of the application that created the
    /// client-affine subscription.
    /// </summary>
    public BicepValue<string> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<string>? _clientId;

    /// <summary>
    /// For client-affine subscriptions, this value indicates whether the
    /// subscription is durable or not.
    /// </summary>
    public BicepValue<bool> IsDurable 
    {
        get { Initialize(); return _isDurable!; }
        set { Initialize(); _isDurable!.Assign(value); }
    }
    private BicepValue<bool>? _isDurable;

    /// <summary>
    /// For client-affine subscriptions, this value indicates whether the
    /// subscription is shared or not.
    /// </summary>
    public BicepValue<bool> IsShared 
    {
        get { Initialize(); return _isShared!; }
        set { Initialize(); _isShared!.Assign(value); }
    }
    private BicepValue<bool>? _isShared;

    /// <summary>
    /// Creates a new ServiceBusClientAffineProperties.
    /// </summary>
    public ServiceBusClientAffineProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ServiceBusClientAffineProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<string>("ClientId", ["clientId"]);
        _isDurable = DefineProperty<bool>("IsDurable", ["isDurable"]);
        _isShared = DefineProperty<bool>("IsShared", ["isShared"]);
    }
}
