// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Namespace/ServiceBus Connection String.
/// </summary>
public partial class ServiceBusAccessKeys : ProvisionableConstruct
{
    /// <summary>
    /// Primary connection string of the created namespace authorization rule.
    /// </summary>
    public BicepValue<string> PrimaryConnectionString 
    {
        get { Initialize(); return _primaryConnectionString!; }
    }
    private BicepValue<string>? _primaryConnectionString;

    /// <summary>
    /// Secondary connection string of the created namespace authorization rule.
    /// </summary>
    public BicepValue<string> SecondaryConnectionString 
    {
        get { Initialize(); return _secondaryConnectionString!; }
    }
    private BicepValue<string>? _secondaryConnectionString;

    /// <summary>
    /// Primary connection string of the alias if GEO DR is enabled.
    /// </summary>
    public BicepValue<string> AliasPrimaryConnectionString 
    {
        get { Initialize(); return _aliasPrimaryConnectionString!; }
    }
    private BicepValue<string>? _aliasPrimaryConnectionString;

    /// <summary>
    /// Secondary  connection string of the alias if GEO DR is enabled.
    /// </summary>
    public BicepValue<string> AliasSecondaryConnectionString 
    {
        get { Initialize(); return _aliasSecondaryConnectionString!; }
    }
    private BicepValue<string>? _aliasSecondaryConnectionString;

    /// <summary>
    /// A base64-encoded 256-bit primary key for signing and validating the SAS
    /// token.
    /// </summary>
    public BicepValue<string> PrimaryKey 
    {
        get { Initialize(); return _primaryKey!; }
    }
    private BicepValue<string>? _primaryKey;

    /// <summary>
    /// A base64-encoded 256-bit primary key for signing and validating the SAS
    /// token.
    /// </summary>
    public BicepValue<string> SecondaryKey 
    {
        get { Initialize(); return _secondaryKey!; }
    }
    private BicepValue<string>? _secondaryKey;

    /// <summary>
    /// A string that describes the authorization rule.
    /// </summary>
    public BicepValue<string> KeyName 
    {
        get { Initialize(); return _keyName!; }
    }
    private BicepValue<string>? _keyName;

    /// <summary>
    /// Creates a new ServiceBusAccessKeys.
    /// </summary>
    public ServiceBusAccessKeys()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceBusAccessKeys.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primaryConnectionString = DefineProperty<string>("PrimaryConnectionString", ["primaryConnectionString"], isOutput: true, isSecure: true);
        _secondaryConnectionString = DefineProperty<string>("SecondaryConnectionString", ["secondaryConnectionString"], isOutput: true, isSecure: true);
        _aliasPrimaryConnectionString = DefineProperty<string>("AliasPrimaryConnectionString", ["aliasPrimaryConnectionString"], isOutput: true, isSecure: true);
        _aliasSecondaryConnectionString = DefineProperty<string>("AliasSecondaryConnectionString", ["aliasSecondaryConnectionString"], isOutput: true, isSecure: true);
        _primaryKey = DefineProperty<string>("PrimaryKey", ["primaryKey"], isOutput: true, isSecure: true);
        _secondaryKey = DefineProperty<string>("SecondaryKey", ["secondaryKey"], isOutput: true, isSecure: true);
        _keyName = DefineProperty<string>("KeyName", ["keyName"], isOutput: true);
    }
}
