// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// Message Count Details.
/// </summary>
public partial class MessageCountDetails : ProvisionableConstruct
{
    /// <summary>
    /// Number of active messages in the queue, topic, or subscription.
    /// </summary>
    public BicepValue<long> ActiveMessageCount 
    {
        get { Initialize(); return _activeMessageCount!; }
    }
    private BicepValue<long>? _activeMessageCount;

    /// <summary>
    /// Number of messages that are dead lettered.
    /// </summary>
    public BicepValue<long> DeadLetterMessageCount 
    {
        get { Initialize(); return _deadLetterMessageCount!; }
    }
    private BicepValue<long>? _deadLetterMessageCount;

    /// <summary>
    /// Number of scheduled messages.
    /// </summary>
    public BicepValue<long> ScheduledMessageCount 
    {
        get { Initialize(); return _scheduledMessageCount!; }
    }
    private BicepValue<long>? _scheduledMessageCount;

    /// <summary>
    /// Number of messages transferred to another queue, topic, or subscription.
    /// </summary>
    public BicepValue<long> TransferMessageCount 
    {
        get { Initialize(); return _transferMessageCount!; }
    }
    private BicepValue<long>? _transferMessageCount;

    /// <summary>
    /// Number of messages transferred into dead letters.
    /// </summary>
    public BicepValue<long> TransferDeadLetterMessageCount 
    {
        get { Initialize(); return _transferDeadLetterMessageCount!; }
    }
    private BicepValue<long>? _transferDeadLetterMessageCount;

    /// <summary>
    /// Creates a new MessageCountDetails.
    /// </summary>
    public MessageCountDetails()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MessageCountDetails.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _activeMessageCount = DefineProperty<long>("ActiveMessageCount", ["activeMessageCount"], isOutput: true);
        _deadLetterMessageCount = DefineProperty<long>("DeadLetterMessageCount", ["deadLetterMessageCount"], isOutput: true);
        _scheduledMessageCount = DefineProperty<long>("ScheduledMessageCount", ["scheduledMessageCount"], isOutput: true);
        _transferMessageCount = DefineProperty<long>("TransferMessageCount", ["transferMessageCount"], isOutput: true);
        _transferDeadLetterMessageCount = DefineProperty<long>("TransferDeadLetterMessageCount", ["transferDeadLetterMessageCount"], isOutput: true);
    }
}
