// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ServiceBus;

/// <summary>
/// MigrationConfiguration.
/// </summary>
public partial class MigrationConfiguration : ProvisionableResource
{
    private BicepValue<string>? _name;

    /// <summary>
    /// Name to access Standard Namespace after migration.
    /// </summary>
    public BicepValue<string> PostMigrationName 
    {
        get { Initialize(); return _postMigrationName!; }
        set { Initialize(); _postMigrationName!.Assign(value); }
    }
    private BicepValue<string>? _postMigrationName;

    /// <summary>
    /// Existing premium Namespace ARM Id name which has no entities, will be
    /// used for migration.
    /// </summary>
    public BicepValue<ResourceIdentifier> TargetServiceBusNamespace 
    {
        get { Initialize(); return _targetServiceBusNamespace!; }
        set { Initialize(); _targetServiceBusNamespace!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _targetServiceBusNamespace;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The geo-location where the resource lives.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// State in which Standard to Premium Migration is, possible values :
    /// Unknown, Reverting, Completing, Initiating, Syncing, Active.
    /// </summary>
    public BicepValue<string> MigrationState 
    {
        get { Initialize(); return _migrationState!; }
    }
    private BicepValue<string>? _migrationState;

    /// <summary>
    /// Number of entities pending to be replicated.
    /// </summary>
    public BicepValue<long> PendingReplicationOperationsCount 
    {
        get { Initialize(); return _pendingReplicationOperationsCount!; }
    }
    private BicepValue<long>? _pendingReplicationOperationsCount;

    /// <summary>
    /// Provisioning state of Migration Configuration.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ServiceBusNamespace.
    /// </summary>
    public ServiceBusNamespace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ServiceBusNamespace>? _parent;

    /// <summary>
    /// Get the default value for the Name property.
    /// </summary>
    private partial BicepValue<string> GetNameDefaultValue();

    /// <summary>
    /// Creates a new MigrationConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the MigrationConfiguration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the MigrationConfiguration.</param>
    public MigrationConfiguration(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ServiceBus/namespaces/migrationConfigurations", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of MigrationConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true, defaultValue: GetNameDefaultValue());
        _postMigrationName = DefineProperty<string>("PostMigrationName", ["properties", "postMigrationName"]);
        _targetServiceBusNamespace = DefineProperty<ResourceIdentifier>("TargetServiceBusNamespace", ["properties", "targetNamespace"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _migrationState = DefineProperty<string>("MigrationState", ["properties", "migrationState"], isOutput: true);
        _pendingReplicationOperationsCount = DefineProperty<long>("PendingReplicationOperationsCount", ["properties", "pendingReplicationOperationsCount"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ServiceBusNamespace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported MigrationConfiguration resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2021-11-01.
        /// </summary>
        public static readonly string V2021_11_01 = "2021-11-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing MigrationConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the MigrationConfiguration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the MigrationConfiguration.</param>
    /// <returns>The existing MigrationConfiguration resource.</returns>
    public static MigrationConfiguration FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
