// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.Search;

/// <summary>
/// Built-in Search roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct SearchBuiltInRole(string value) : IEquatable<SearchBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Grants full access to Azure Cognitive Search index data.
    /// </summary>
    public static SearchBuiltInRole SearchIndexDataContributor { get; } = new(SearchIndexDataContributorValue);
    internal const string SearchIndexDataContributorValue = "8ebe5a00-799e-43f5-93ac-243d3dce84a7";

    /// <summary>
    /// Grants read access to Azure Cognitive Search index data.
    /// </summary>
    public static SearchBuiltInRole SearchIndexDataReader { get; } = new(SearchIndexDataReaderValue);
    internal const string SearchIndexDataReaderValue = "1407120a-92aa-4202-b7e9-c0e197c71c8f";

    /// <summary>
    /// Lets you manage Search services, but not access to them.
    /// </summary>
    public static SearchBuiltInRole SearchServiceContributor { get; } = new(SearchServiceContributorValue);
    internal const string SearchServiceContributorValue = "7ca78c08-252a-4471-8644-bb5ff32d4ba0";

    /// <summary>
    /// Try to get the name of a built-in Search role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in Search role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(SearchBuiltInRole value) =>
        value._value switch
        {
            SearchIndexDataContributorValue => nameof(SearchIndexDataContributor),
            SearchIndexDataReaderValue => nameof(SearchIndexDataReader),
            SearchServiceContributorValue => nameof(SearchServiceContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two SearchBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first SearchBuiltInRole to compare.</param>
    /// <param name="right">The second SearchBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(SearchBuiltInRole left, SearchBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two SearchBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first SearchBuiltInRole to compare.</param>
    /// <param name="right">The second SearchBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(SearchBuiltInRole left, SearchBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a SearchBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator SearchBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is SearchBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(SearchBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
