// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.Search;

/// <summary>
/// The status of the search service. Possible values include:
/// &apos;running&apos;: The search service is running and no provisioning
/// operations are underway. &apos;provisioning&apos;: The search service is
/// being provisioned or scaled up or down. &apos;deleting&apos;: The search
/// service is being deleted. &apos;degraded&apos;: The search service is
/// degraded. This can occur when the underlying search units are not healthy.
/// The search service is most likely operational, but performance might be
/// slow and some requests might be dropped. &apos;disabled&apos;: The search
/// service is disabled. In this state, the service will reject all API
/// requests. &apos;error&apos;: The search service is in an error state.
/// &apos;stopped&apos;: The search service is in a subscription that&apos;s
/// disabled. If your service is in the degraded, disabled, or error states,
/// it means the Azure AI Search team is actively investigating the underlying
/// issue. Dedicated services in these states are still chargeable based on
/// the number of search units provisioned.
/// </summary>
public enum SearchServiceStatus
{
    /// <summary>
    /// The search service is running and no provisioning operations are
    /// underway.
    /// </summary>
    [DataMember(Name = "running")]
    Running,

    /// <summary>
    /// The search service is being provisioned or scaled up or down.
    /// </summary>
    [DataMember(Name = "provisioning")]
    Provisioning,

    /// <summary>
    /// The search service is being deleted.
    /// </summary>
    [DataMember(Name = "deleting")]
    Deleting,

    /// <summary>
    /// The search service is degraded because underlying search units are not
    /// healthy.
    /// </summary>
    [DataMember(Name = "degraded")]
    Degraded,

    /// <summary>
    /// The search service is disabled and all API requests will be rejected.
    /// </summary>
    [DataMember(Name = "disabled")]
    Disabled,

    /// <summary>
    /// The search service is in error state, indicating either a failure to
    /// provision or to be deleted.
    /// </summary>
    [DataMember(Name = "error")]
    Error,
}
