// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.Search;

/// <summary>
/// The SKU of the search service. Valid values include: &apos;free&apos;:
/// Shared service. &apos;basic&apos;: Dedicated service with up to 3
/// replicas. &apos;standard&apos;: Dedicated service with up to 12 partitions
/// and 12 replicas. &apos;standard2&apos;: Similar to standard, but with more
/// capacity per search unit. &apos;standard3&apos;: The largest Standard
/// offering with up to 12 partitions and 12 replicas (or up to 3 partitions
/// with more indexes if you also set the hostingMode property to
/// &apos;highDensity&apos;). &apos;storage_optimized_l1&apos;: Supports 1TB
/// per partition, up to 12 partitions. &apos;storage_optimized_l2&apos;:
/// Supports 2TB per partition, up to 12 partitions.&apos;.
/// </summary>
public enum SearchServiceSkuName
{
    /// <summary>
    /// Free tier, with no SLA guarantees and a subset of the features offered
    /// on billable tiers.
    /// </summary>
    [DataMember(Name = "free")]
    Free,

    /// <summary>
    /// Billable tier for a dedicated service having up to 3 replicas.
    /// </summary>
    [DataMember(Name = "basic")]
    Basic,

    /// <summary>
    /// Billable tier for a dedicated service having up to 12 partitions and 12
    /// replicas.
    /// </summary>
    [DataMember(Name = "standard")]
    Standard,

    /// <summary>
    /// Similar to &apos;standard&apos;, but with more capacity per search unit.
    /// </summary>
    [DataMember(Name = "standard2")]
    Standard2,

    /// <summary>
    /// The largest Standard offering with up to 12 partitions and 12 replicas
    /// (or up to 3 partitions with more indexes if you also set the
    /// hostingMode property to &apos;highDensity&apos;).
    /// </summary>
    [DataMember(Name = "standard3")]
    Standard3,

    /// <summary>
    /// Billable tier for a dedicated service that supports 1TB per partition,
    /// up to 12 partitions.
    /// </summary>
    [DataMember(Name = "storage_optimized_l1")]
    StorageOptimizedL1,

    /// <summary>
    /// Billable tier for a dedicated service that supports 2TB per partition,
    /// up to 12 partitions.
    /// </summary>
    [DataMember(Name = "storage_optimized_l2")]
    StorageOptimizedL2,
}
